/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.usercommunication.dm.service;

import com.finconsgroup.itserr.marketplace.usercommunication.dm.constant.SecurityConstants;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.entity.ChatMessage;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.enums.MessageType;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.service.MessagingService;
import java.time.Instant;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ChatMessageProducer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ChatMessageProducer.class);
    private final MessagingService messagingService;

    public void sendChatMessage(ChatMessage message) {
        try {
            if (message.getId() == null) {
                message.setId(UUID.randomUUID());
            }
            if (message.getCreatedAt() == null) {
                message.setCreatedAt(Instant.now());
            }
            this.messagingService.sendChatMessage(message);
            log.info("Chat message sent successfully: {}", (Object)message.getId());
        }
        catch (Exception e) {
            log.error("Failed to send chat message: {}", (Object)message.getId(), (Object)e);
            throw new RuntimeException("Failed to send chat message", e);
        }
    }

    public void sendUserNotification(UUID userId, String content, MessageType messageType) {
        try {
            ChatMessage notification = new ChatMessage();
            notification.setId(UUID.randomUUID());
            notification.setSenderId(SecurityConstants.SYSTEM_USER_ID);
            notification.setReceiverId(userId);
            notification.setContent(content);
            notification.setMessageType(messageType);
            notification.setCreatedAt(Instant.now());
            log.info("Sending user notification to user: {} with type: {}", (Object)userId, (Object)messageType);
            this.messagingService.sendUserNotification(notification);
            log.info("User notification sent successfully to user: {}", (Object)userId);
        }
        catch (Exception e) {
            log.error("Failed to send user notification to user: {}", (Object)userId, (Object)e);
            throw new RuntimeException("Failed to send user notification", e);
        }
    }

    @Generated
    public ChatMessageProducer(MessagingService messagingService) {
        this.messagingService = messagingService;
    }
}

