/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.usercommunication.dm.repository;

import com.finconsgroup.itserr.marketplace.usercommunication.dm.entity.OfflineMessage;
import java.time.Instant;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface OfflineMessageRepository
extends JpaRepository<OfflineMessage, UUID> {
    public List<OfflineMessage> findByRecipientUserIdAndDeliveredFalseOrderByCreatedAtAsc(UUID var1);

    public Optional<OfflineMessage> findTop1ByRecipientUserIdAndDeliveredFalseOrderByCreatedAtAsc(UUID var1);

    @Modifying
    @Query(value="UPDATE OfflineMessage om SET om.delivered = true, om.deliveredAt = :deliveredAt WHERE om.recipientUserId = :recipientUserId AND om.delivered = false")
    public int markMessagesAsDelivered(@Param(value="recipientUserId") UUID var1, @Param(value="deliveredAt") Instant var2);

    @Modifying
    @Query(value="UPDATE OfflineMessage om SET om.delivered = true, om.deliveredAt = :deliveredAt WHERE om.id IN :messageIds")
    public int markSpecificMessagesAsDelivered(@Param(value="messageIds") List<Long> var1, @Param(value="deliveredAt") Instant var2);

    public long countByRecipientUserIdAndDeliveredFalse(UUID var1);

    public long countByRecipientUserIdAndConversationIdAndDeliveredFalse(UUID var1, UUID var2);

    @Modifying
    @Query(value="DELETE FROM OfflineMessage om WHERE om.delivered = true AND om.deliveredAt < :cutoffDate")
    public int deleteDeliveredMessagesOlderThan(@Param(value="cutoffDate") Instant var1);

    public boolean existsByMessageIdAndRecipientUserId(UUID var1, UUID var2);

    @Modifying
    @Query(value="DELETE FROM OfflineMessage om WHERE om.recipientUserId = :recipientUserId AND om.conversationId = :conversationId AND om.delivered = true")
    public int deleteByRecipientUserIdAndConversationIdAndDeliveredTrue(@Param(value="recipientUserId") UUID var1, @Param(value="conversationId") UUID var2);

    @Modifying
    @Query(value="DELETE FROM OfflineMessage om WHERE om.recipientUserId = :recipientUserId AND om.conversationId = :conversationId AND om.delivered = false")
    public int deleteByRecipientUserIdAndConversationIdAndDeliveredFalse(@Param(value="recipientUserId") UUID var1, @Param(value="conversationId") UUID var2);

    @Modifying
    @Query(value="DELETE FROM OfflineMessage om WHERE om.recipientUserId = :recipientUserId AND om.conversationId = :conversationId AND om.delivered = false AND om.createdAt <= :uptoCreatedAt")
    public int deleteByRecipientUserIdAndConversationIdAndDeliveredFalseUptoCreatedAt(@Param(value="recipientUserId") UUID var1, @Param(value="conversationId") UUID var2, @Param(value="uptoCreatedAt") Instant var3);

    @Modifying
    @Query(value="DELETE FROM OfflineMessage om WHERE om.recipientUserId = :recipientUserId AND om.conversationId = :conversationId AND om.delivered = false AND om.messageId IN (:messageIds)")
    public int deleteByRecipientUserIdAndConversationIdAndDeliveredFalseAndMessageIdIn(@Param(value="recipientUserId") UUID var1, @Param(value="conversationId") UUID var2, @Param(value="messageIds") Set<UUID> var3);
}

