/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.usercommunication.dm.repository;

import com.finconsgroup.itserr.marketplace.usercommunication.dm.entity.Conversation;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.enums.ConversationType;
import java.time.Instant;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Repository;

@Repository
public interface ConversationRepository
extends JpaRepository<Conversation, UUID> {
    public static final Map<String, String> FIELD_COLUMN_NAME_MAP = Map.ofEntries(Map.entry("id", "id"), Map.entry("name", "name"), Map.entry("description", "description"), Map.entry("createdBy", "created_by"), Map.entry("createdAt", "created_at"), Map.entry("lastActivity", "last_activity"), Map.entry("active", "active"), Map.entry("privateFlag", "is_private"), Map.entry("maxParticipants", "max_participants"), Map.entry("participantOneId", "participant_one_id"), Map.entry("participantTwoId", "participant_two_id"));

    @NonNull
    public Optional<Conversation> findById(@NonNull UUID var1);

    public boolean existsByIdAndActiveTrue(@NonNull UUID var1);

    @Query(value="SELECT c FROM Conversation c JOIN ConversationParticipant cp ON cp.conversationId = c.id WHERE cp.userId = :userId AND cp.active = true AND c.active = true")
    public Page<Conversation> findConversationsForUser(@Param(value="userId") UUID var1, Pageable var2);

    @Query(value="SELECT c FROM Conversation c WHERE c.conversationType = 'DIRECT' AND c.active = true AND ((c.participantOneId = :user1Id AND c.participantTwoId = :user2Id) OR (c.participantOneId = :user2Id AND c.participantTwoId = :user1Id))")
    public Optional<Conversation> findDirectConversationBetweenUsers(@Param(value="user1Id") UUID var1, @Param(value="user2Id") UUID var2);

    @Query(value="SELECT c.*\nFROM conversations c\nJOIN conversation_participants cp\n    ON    cp.conversation_id = c.id\n      AND cp.user_id = :userId AND cp.is_active = true\nWHERE   c.active = true\n   AND (\n           (c.conversation_type = 'GROUP' AND LOWER(c.name) LIKE LOWER('%' || :term || '%'))\n      OR  (\n              c.conversation_type = 'DIRECT'\n          AND EXISTS (\n                SELECT 1 FROM conversation_participants cp2\n                JOIN users u on u.id = cp2.user_id\n                WHERE cp2.conversation_id = c.id AND cp2.is_active = true\n                AND LOWER(u.first_name || ' ' || u.last_name) LIKE LOWER('%' || :term || '%')\n              )\n      )\n   )\n", countQuery="SELECT COUNT(c.id)\nFROM conversations c\nJOIN conversation_participants cp\n    ON    cp.conversation_id = c.id\n      AND cp.user_id = :userId AND cp.is_active = true\nWHERE   c.active = true\n   AND (\n           (c.conversation_type = 'GROUP' AND LOWER(c.name) LIKE LOWER('%' || :term || '%'))\n      OR  (\n              c.conversation_type = 'DIRECT'\n          AND EXISTS (\n                SELECT 1 FROM conversation_participants cp2\n                JOIN users u on u.id = cp2.user_id\n                WHERE cp2.conversation_id = c.id AND cp2.is_active = true\n                AND LOWER(u.first_name || ' ' || u.last_name) LIKE LOWER('%' || :term || '%')\n              )\n      )\n   )\n", nativeQuery=true)
    public Page<Conversation> findByNameContainingIgnoreCase(@Param(value="userId") UUID var1, @Param(value="term") String var2, Pageable var3);

    public long countByConversationTypeAndActiveTrue(ConversationType var1);

    @Modifying
    @Query(value="UPDATE Conversation c SET c.lastActivity = :timestamp WHERE c.id = :conversationId")
    public void updateLastActivity(@Param(value="conversationId") UUID var1, @Param(value="timestamp") Instant var2);

    @Modifying
    @Query(value="UPDATE Conversation c SET c.active = false WHERE c.id = :conversationId")
    public void deactivateConversation(@Param(value="conversationId") UUID var1);

    @Modifying
    @Query(value="UPDATE Conversation c SET c.active = true WHERE c.id = :conversationId")
    public void activateConversation(@Param(value="conversationId") UUID var1);

    @Query(value="SELECT CASE WHEN COUNT(c) > 0 THEN true ELSE false END FROM Conversation c WHERE c.conversationType = 'DIRECT' AND c.active = true AND ((c.participantOneId = :user1Id AND c.participantTwoId = :user2Id) OR (c.participantOneId = :user2Id AND c.participantTwoId = :user1Id))")
    public boolean existsDirectConversationBetweenUsers(@Param(value="user1Id") UUID var1, @Param(value="user2Id") UUID var2);
}

