/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.usercommunication.dm.entity;

import com.finconsgroup.itserr.marketplace.core.entity.AbstractUUIDEntity;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.entity.Conversation;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.enums.ConversationType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.Table;
import jakarta.validation.constraints.NotNull;
import java.time.Instant;
import java.util.UUID;
import lombok.Generated;

@Entity
@Table(name="conversations")
public class Conversation
extends AbstractUUIDEntity {
    @Enumerated(value=EnumType.STRING)
    @Column(name="conversation_type", nullable=false)
    @NotNull(message="Conversation type cannot be null")
    private @NotNull(message="Conversation type cannot be null") ConversationType conversationType;
    @Column(name="name")
    private String name;
    @Column(name="description", columnDefinition="TEXT")
    private String description;
    @Column(name="created_by", nullable=false)
    @NotNull(message="Created by cannot be blank")
    private @NotNull(message="Created by cannot be blank") UUID createdBy;
    @Column(name="created_at", nullable=false)
    private Instant createdAt;
    @Column(name="last_activity", nullable=false)
    private Instant lastActivity;
    @Column(name="active", nullable=false)
    private boolean active;
    @Column(name="is_private", nullable=false)
    private boolean privateFlag;
    @Column(name="max_participants")
    private Integer maxParticipants;
    @Column(name="participant_one_id")
    private UUID participantOneId;
    @Column(name="participant_two_id")
    private UUID participantTwoId;

    public Conversation(UUID conversationId, ConversationType conversationType, UUID createdBy) {
        this();
        this.setId(conversationId);
        this.conversationType = conversationType;
        this.createdBy = createdBy;
        switch (1.$SwitchMap$com$finconsgroup$itserr$marketplace$usercommunication$dm$enums$ConversationType[conversationType.ordinal()]) {
            case 1: {
                this.privateFlag = true;
                this.maxParticipants = 2;
                break;
            }
            case 2: {
                this.privateFlag = true;
                this.maxParticipants = 50;
            }
        }
    }

    public void prePersist() {
        super.prePersist();
        this.createdAt = Instant.now();
        this.lastActivity = Instant.now();
        this.active = true;
    }

    public static Conversation createDirectConversation(UUID conversationId, UUID user1Id, UUID user2Id) {
        Conversation conversation = new Conversation(conversationId, ConversationType.DIRECT, user1Id);
        conversation.setParticipantOneId(user1Id);
        conversation.setParticipantTwoId(user2Id);
        conversation.setName(null);
        return conversation;
    }

    public static Conversation createGroupConversation(UUID conversationId, String name, UUID createdBy) {
        Conversation conversation = new Conversation(conversationId, ConversationType.GROUP, createdBy);
        conversation.setName(name);
        return conversation;
    }

    public boolean isDirect() {
        return this.conversationType == ConversationType.DIRECT;
    }

    public boolean isGroup() {
        return this.conversationType == ConversationType.GROUP;
    }

    public boolean isDirectParticipant(UUID userId) {
        return this.isDirect() && (userId.equals(this.participantOneId) || userId.equals(this.participantTwoId));
    }

    public UUID getOtherParticipantId(UUID userId) {
        if (!this.isDirect()) {
            return null;
        }
        if (userId.equals(this.participantOneId)) {
            return this.participantTwoId;
        }
        if (userId.equals(this.participantTwoId)) {
            return this.participantOneId;
        }
        return null;
    }

    @Generated
    protected Conversation(ConversationBuilder<?, ?> b) {
        super(b);
        this.conversationType = b.conversationType;
        this.name = b.name;
        this.description = b.description;
        this.createdBy = b.createdBy;
        this.createdAt = b.createdAt;
        this.lastActivity = b.lastActivity;
        this.active = b.active;
        this.privateFlag = b.privateFlag;
        this.maxParticipants = b.maxParticipants;
        this.participantOneId = b.participantOneId;
        this.participantTwoId = b.participantTwoId;
    }

    @Generated
    public static ConversationBuilder<?, ?> builder() {
        return new ConversationBuilderImpl();
    }

    @Generated
    public ConversationType getConversationType() {
        return this.conversationType;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public UUID getCreatedBy() {
        return this.createdBy;
    }

    @Generated
    public Instant getCreatedAt() {
        return this.createdAt;
    }

    @Generated
    public Instant getLastActivity() {
        return this.lastActivity;
    }

    @Generated
    public boolean isActive() {
        return this.active;
    }

    @Generated
    public boolean isPrivateFlag() {
        return this.privateFlag;
    }

    @Generated
    public Integer getMaxParticipants() {
        return this.maxParticipants;
    }

    @Generated
    public UUID getParticipantOneId() {
        return this.participantOneId;
    }

    @Generated
    public UUID getParticipantTwoId() {
        return this.participantTwoId;
    }

    @Generated
    public void setConversationType(ConversationType conversationType) {
        this.conversationType = conversationType;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setCreatedBy(UUID createdBy) {
        this.createdBy = createdBy;
    }

    @Generated
    public void setCreatedAt(Instant createdAt) {
        this.createdAt = createdAt;
    }

    @Generated
    public void setLastActivity(Instant lastActivity) {
        this.lastActivity = lastActivity;
    }

    @Generated
    public void setActive(boolean active) {
        this.active = active;
    }

    @Generated
    public void setPrivateFlag(boolean privateFlag) {
        this.privateFlag = privateFlag;
    }

    @Generated
    public void setMaxParticipants(Integer maxParticipants) {
        this.maxParticipants = maxParticipants;
    }

    @Generated
    public void setParticipantOneId(UUID participantOneId) {
        this.participantOneId = participantOneId;
    }

    @Generated
    public void setParticipantTwoId(UUID participantTwoId) {
        this.participantTwoId = participantTwoId;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Conversation)) {
            return false;
        }
        Conversation other = (Conversation)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isActive() != other.isActive()) {
            return false;
        }
        if (this.isPrivateFlag() != other.isPrivateFlag()) {
            return false;
        }
        Integer this$maxParticipants = this.getMaxParticipants();
        Integer other$maxParticipants = other.getMaxParticipants();
        if (this$maxParticipants == null ? other$maxParticipants != null : !((Object)this$maxParticipants).equals(other$maxParticipants)) {
            return false;
        }
        ConversationType this$conversationType = this.getConversationType();
        ConversationType other$conversationType = other.getConversationType();
        if (this$conversationType == null ? other$conversationType != null : !this$conversationType.equals(other$conversationType)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        UUID this$createdBy = this.getCreatedBy();
        UUID other$createdBy = other.getCreatedBy();
        if (this$createdBy == null ? other$createdBy != null : !((Object)this$createdBy).equals(other$createdBy)) {
            return false;
        }
        Instant this$createdAt = this.getCreatedAt();
        Instant other$createdAt = other.getCreatedAt();
        if (this$createdAt == null ? other$createdAt != null : !((Object)this$createdAt).equals(other$createdAt)) {
            return false;
        }
        Instant this$lastActivity = this.getLastActivity();
        Instant other$lastActivity = other.getLastActivity();
        if (this$lastActivity == null ? other$lastActivity != null : !((Object)this$lastActivity).equals(other$lastActivity)) {
            return false;
        }
        UUID this$participantOneId = this.getParticipantOneId();
        UUID other$participantOneId = other.getParticipantOneId();
        if (this$participantOneId == null ? other$participantOneId != null : !((Object)this$participantOneId).equals(other$participantOneId)) {
            return false;
        }
        UUID this$participantTwoId = this.getParticipantTwoId();
        UUID other$participantTwoId = other.getParticipantTwoId();
        return !(this$participantTwoId == null ? other$participantTwoId != null : !((Object)this$participantTwoId).equals(other$participantTwoId));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Conversation;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isActive() ? 79 : 97);
        result = result * 59 + (this.isPrivateFlag() ? 79 : 97);
        Integer $maxParticipants = this.getMaxParticipants();
        result = result * 59 + ($maxParticipants == null ? 43 : ((Object)$maxParticipants).hashCode());
        ConversationType $conversationType = this.getConversationType();
        result = result * 59 + ($conversationType == null ? 43 : $conversationType.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        UUID $createdBy = this.getCreatedBy();
        result = result * 59 + ($createdBy == null ? 43 : ((Object)$createdBy).hashCode());
        Instant $createdAt = this.getCreatedAt();
        result = result * 59 + ($createdAt == null ? 43 : ((Object)$createdAt).hashCode());
        Instant $lastActivity = this.getLastActivity();
        result = result * 59 + ($lastActivity == null ? 43 : ((Object)$lastActivity).hashCode());
        UUID $participantOneId = this.getParticipantOneId();
        result = result * 59 + ($participantOneId == null ? 43 : ((Object)$participantOneId).hashCode());
        UUID $participantTwoId = this.getParticipantTwoId();
        result = result * 59 + ($participantTwoId == null ? 43 : ((Object)$participantTwoId).hashCode());
        return result;
    }

    @Generated
    public Conversation() {
    }
}

