/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.usercommunication.dm.controller;

import com.finconsgroup.itserr.marketplace.usercommunication.dm.api.WebSocketChatApi;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.constant.MessageDestinations;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.constant.MessageHeaders;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.constant.SecurityConstants;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.dto.InputChatMessageDto;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.dto.InputTypingMessageDto;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.dto.OutputChatMessageDto;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.entity.ChatMessage;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.enums.MessageType;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.security.WebSocketAuthentication;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.service.WebSocketService;
import jakarta.validation.Valid;
import java.time.Instant;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.messaging.handler.annotation.DestinationVariable;
import org.springframework.messaging.handler.annotation.MessageMapping;
import org.springframework.messaging.handler.annotation.Payload;
import org.springframework.messaging.simp.SimpMessageHeaderAccessor;
import org.springframework.messaging.simp.SimpMessagingTemplate;
import org.springframework.stereotype.Controller;

@Controller
public class WebSocketChatController
implements WebSocketChatApi {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WebSocketChatController.class);
    private final SimpMessagingTemplate messagingTemplate;
    private final WebSocketService webSocketService;
    private final MessageDestinations messageDestinations;

    @MessageMapping(value={"/conversation/{conversationId}"})
    public void sendMessage(@DestinationVariable UUID conversationId, @Valid @Payload InputChatMessageDto inputChatMessageDto, WebSocketAuthentication authentication, SimpMessageHeaderAccessor headerAccessor) {
        try {
            UUID userId = authentication.getPrincipal().getUserId();
            OutputChatMessageDto outputChatMessageDto = this.webSocketService.sendMessage(userId, conversationId, inputChatMessageDto);
            outputChatMessageDto.setRequestMessageId(headerAccessor.getFirstNativeHeader("requestMessageId"));
            this.messagingTemplate.convertAndSend((Object)this.messageDestinations.getConversationTopic(conversationId), (Object)outputChatMessageDto);
        }
        catch (Exception e) {
            log.error("Failed to process WebSocket message for conversation {}: {}", new Object[]{conversationId, e.getMessage(), e});
        }
    }

    @MessageMapping(value={"/conversation/{conversationId}/join"})
    public void addUser(@DestinationVariable UUID conversationId, @Payload InputChatMessageDto inputChatMessageDto, WebSocketAuthentication authentication, SimpMessageHeaderAccessor headerAccessor) {
        try {
            UUID userId = authentication.getPrincipal().getUserId();
            OutputChatMessageDto chatMessageDto = this.webSocketService.addUser(userId, conversationId, inputChatMessageDto);
            this.messagingTemplate.convertAndSend((Object)this.messageDestinations.getConversationTopic(conversationId), (Object)chatMessageDto);
        }
        catch (Exception e) {
            log.error("Failed to process join message for conversation {}: {}", new Object[]{conversationId, e.getMessage(), e});
        }
    }

    @MessageMapping(value={"/conversation/{conversationId}/leave"})
    public void removeUser(@DestinationVariable UUID conversationId, @Payload InputChatMessageDto inputChatMessageDto, WebSocketAuthentication authentication, SimpMessageHeaderAccessor headerAccessor) {
        try {
            UUID userId = authentication.getPrincipal().getUserId();
            OutputChatMessageDto chatMessageDto = this.webSocketService.removeUser(userId, conversationId, inputChatMessageDto);
            this.messagingTemplate.convertAndSend((Object)this.messageDestinations.getConversationTopic(conversationId), (Object)chatMessageDto);
        }
        catch (Exception e) {
            log.error("Failed to process leave message for conversation {}: {}", new Object[]{conversationId, e.getMessage(), e});
        }
    }

    @MessageMapping(value={"/conversation/{conversationId}/typing"})
    public void sendTypingIndicator(@DestinationVariable UUID conversationId, @Payload InputTypingMessageDto inputTypingMessageDto, WebSocketAuthentication authentication) {
        try {
            UUID userId = authentication.getPrincipal().getUserId();
            OutputChatMessageDto chatMessageDto = this.webSocketService.sendTypingIndicator(userId, conversationId, inputTypingMessageDto);
            this.messagingTemplate.convertAndSend((Object)this.messageDestinations.getConversationTypingTopic(conversationId), (Object)chatMessageDto);
        }
        catch (Exception e) {
            log.error("Failed to send typing indicator for conversation {}: {}", new Object[]{conversationId, e.getMessage(), e});
        }
    }

    @MessageMapping(value={"/conversation/direct/{receiverId}"})
    public void sendDirectMessage(@DestinationVariable UUID receiverId, @Payload InputChatMessageDto inputChatMessageDto, WebSocketAuthentication authentication) {
        try {
            UUID userId = authentication.getPrincipal().getUserId();
            OutputChatMessageDto outputChatMessageDto = this.webSocketService.sendDirectMessage(userId, receiverId, inputChatMessageDto);
            this.messagingTemplate.convertAndSend((Object)this.messageDestinations.getConversationTopic(outputChatMessageDto.getConversationId()), (Object)outputChatMessageDto);
            this.messagingTemplate.convertAndSendToUser(receiverId.toString(), this.messageDestinations.getUserMessagesSuffix(), (Object)outputChatMessageDto, MessageHeaders.USER_DESTINATION_DEFAULTS);
            log.info("Direct message sent from {} to {} in conversation {}: {}", new Object[]{outputChatMessageDto.getSenderId(), receiverId, outputChatMessageDto.getConversationId(), outputChatMessageDto.getId()});
        }
        catch (Exception e) {
            log.error("Failed to send direct message: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    public void broadcastSystemMessage(UUID conversationId, String content) {
        try {
            OutputChatMessageDto outputChatMessageDto = this.webSocketService.broadcastSystemMessage(conversationId, content);
            if (outputChatMessageDto != null) {
                this.messagingTemplate.convertAndSend((Object)this.messageDestinations.getConversationTopic(conversationId), (Object)outputChatMessageDto);
                log.info("System message broadcasted to conversation {}: {}", (Object)conversationId, (Object)content);
            }
        }
        catch (Exception e) {
            log.error("Failed to broadcast system message to conversation {}: {}", new Object[]{conversationId, e.getMessage(), e});
        }
    }

    public void sendUserNotification(UUID userId, String content, MessageType messageType) {
        try {
            OutputChatMessageDto outputChatMessageDto = this.webSocketService.sendUserNotification(userId, content, messageType);
            this.messagingTemplate.convertAndSendToUser(userId.toString(), this.messageDestinations.getUserNotificationsSuffix(), (Object)outputChatMessageDto, MessageHeaders.USER_DESTINATION_DEFAULTS);
            log.info("Notification sent to user {}: {}", (Object)userId, (Object)content);
        }
        catch (Exception e) {
            log.error("Failed to send notification to user {}: {}", new Object[]{userId, e.getMessage(), e});
        }
    }

    public void sendInvitationNotification(UUID conversationId, UUID invitedUserId, WebSocketAuthentication authentication) {
        try {
            UUID userId = authentication.getPrincipal().getUserId();
            OutputChatMessageDto outputChatMessageDto = this.webSocketService.sendInvitation(userId, conversationId, invitedUserId);
            if (outputChatMessageDto != null) {
                this.messagingTemplate.convertAndSendToUser(invitedUserId.toString(), this.messageDestinations.getUserInvitationsSuffix(), (Object)outputChatMessageDto, MessageHeaders.USER_DESTINATION_DEFAULTS);
                log.info("Invitation notification sent to user {} for conversation {}", (Object)invitedUserId, (Object)conversationId);
            }
        }
        catch (Exception e) {
            log.error("Failed to send invitation notification: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    public void broadcastMessageStatusUpdate(UUID conversationId, String messageId, boolean delivered, boolean read, String readByUserId) {
        try {
            ChatMessage statusUpdate = new ChatMessage();
            statusUpdate.setId(UUID.randomUUID());
            statusUpdate.setSenderId(SecurityConstants.SYSTEM_USER_ID);
            statusUpdate.setContent("MESSAGE_STATUS_UPDATE:" + messageId + ":" + delivered + ":" + read + ":" + (readByUserId != null ? readByUserId : ""));
            statusUpdate.setMessageType(MessageType.SYSTEM);
            statusUpdate.setConversationId(conversationId);
            statusUpdate.setCreatedAt(Instant.now());
            statusUpdate.setDelivered(delivered);
            statusUpdate.setReadByReceiver(read);
            this.messagingTemplate.convertAndSend((Object)this.messageDestinations.getConversationChildTopic(conversationId, "status"), (Object)statusUpdate);
            log.debug("Message status update broadcasted for message {} in conversation {}: delivered={}, read={}", new Object[]{messageId, conversationId, delivered, read});
        }
        catch (Exception e) {
            log.error("Failed to broadcast message status update for message {} in conversation {}: {}", new Object[]{messageId, conversationId, e.getMessage(), e});
        }
    }

    @Generated
    public WebSocketChatController(SimpMessagingTemplate messagingTemplate, WebSocketService webSocketService, MessageDestinations messageDestinations) {
        this.messagingTemplate = messagingTemplate;
        this.webSocketService = webSocketService;
        this.messageDestinations = messageDestinations;
    }
}

