package com.finconsgroup.itserr.marketplace.usercommunication.dm.service.impl;

import com.finconsgroup.itserr.marketplace.usercommunication.dm.bean.ChatMessageApplicationEvent;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.entity.ChatMessage;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.service.MessagingService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Service;

import static com.finconsgroup.itserr.marketplace.usercommunication.dm.constant.MessagingType.SPRING_EVENTS;

/**
 * Implementation for {@link MessagingService} that sends the messages as Spring Events.
 */
@Service
@ConditionalOnProperty(value = "type", prefix = "user-communication.dm.messaging", havingValue = SPRING_EVENTS)
@Slf4j
@RequiredArgsConstructor
public class SpringEventMessagingService implements MessagingService {

    private final ApplicationEventPublisher applicationEventPublisher;

    @Override
    public void sendChatMessage(@NonNull ChatMessage chatMessage) {
        log.info("Sending chat message: {} from user: {} using Spring Application Event Publisher",
                chatMessage.getId(), chatMessage.getSenderId());
        applicationEventPublisher.publishEvent(new ChatMessageApplicationEvent(chatMessage, false));
    }

    @Override
    public void sendUserNotification(@NonNull ChatMessage notification) {
        applicationEventPublisher.publishEvent(new ChatMessageApplicationEvent(notification, true));
    }
}
