package com.finconsgroup.itserr.marketplace.usercommunication.dm.security;

import org.springframework.lang.NonNull;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.core.GrantedAuthority;

import java.util.Collection;
import java.util.Objects;

/**
 * The authentication object for Web Socket that represents the currently logged-in user.
 */
public class WebSocketAuthentication extends AbstractAuthenticationToken {

    private final WebSocketUser user;

    public WebSocketAuthentication(@NonNull WebSocketUser user,
                                   Collection<? extends GrantedAuthority> authorities) {
        super(authorities);
        setAuthenticated(true);
        Objects.requireNonNull(user, "user must not be null");
        this.user = user;
    }

    @Override
    public String getName() {
        // This is used for routing messages to user destinations.
        // And so should match the first argument to the convertAndSendToUser
        // method, which is the user's id.
        return user.getUserId().toString();
    }

    @Override
    public Object getCredentials() {
        return null;
    }

    @NonNull
    @Override
    public WebSocketUser getPrincipal() {
        return user;
    }
}
