package com.finconsgroup.itserr.marketplace.usercommunication.dm.exception;

import java.util.List;

/**
 * Dto for sending error responses for web socket messages.
 *
 * <p>This record contains a list of error messages returned in the response body when an exception occurs.</p>
 *
 * <p>Example usage:
 * <pre>
 * List<String> messages = List.of("Error message 1", "Error message 2");
 * MessagingErrorResponseDto errorResponseDto = new MessagingErrorResponseDto(400, messages, destination, stackTrace);
 * </pre>
 * </p>
 *
 * @param code             the status code for the response similar to http status
 * @param messages         the list of error messages
 * @param destination      the destination
 * @param requestMessageId the id to uniquely identify the request that sent the message
 * @param stackTrace       the error stack trace
 */
public record MessagingErrorResponseDto(int code,
                                        List<String> messages,
                                        String destination,
                                        String requestMessageId,
                                        List<String> stackTrace) {

}