package com.finconsgroup.itserr.marketplace.usercommunication.dm.entity;

import com.finconsgroup.itserr.marketplace.core.entity.AbstractUUIDEntity;
import jakarta.persistence.CollectionTable;
import jakarta.persistence.Column;
import jakarta.persistence.ElementCollection;
import jakarta.persistence.Entity;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.Table;
import jakarta.validation.constraints.NotBlank;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.SuperBuilder;

import java.time.Instant;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;

/**
 * Entity representing a chat room that groups participants and tracks metadata
 * like creation time, last activity, active state and capacity.
 */
@Entity
@Table(name = "chat_rooms")
@SuperBuilder
@Getter
@Setter
@EqualsAndHashCode(callSuper = true)
public class ChatRoom extends AbstractUUIDEntity {

    @Column(name = "name", nullable = false)
    @NotBlank(message = "Chat room name cannot be blank")
    private String name;

    @Column(name = "description", columnDefinition = "TEXT")
    private String description;

    @Column(name = "created_by", nullable = false)
    private UUID createdBy;

    @Column(name = "created_at", nullable = false)
    private Instant createdAt;

    @Column(name = "last_activity", nullable = false)
    private Instant lastActivity;

    @ElementCollection
    @CollectionTable(name = "chat_room_participants", joinColumns = @JoinColumn(name = "chat_room_id"))
    @Column(name = "user_id")
    private Set<UUID> participants;

    @Column(name = "active", nullable = false)
    private boolean active;

    @Column(name = "max_participants", nullable = false)
    private int maxParticipants;

    public ChatRoom() {
        this.createdAt = Instant.now();
        this.lastActivity = Instant.now();
        this.participants = new HashSet<>();
        this.active = true;
        this.maxParticipants = 100; // Default max participants
    }

    // TODO: Check Later as this feature is not a priority for now
//    public ChatRoom(UUID chatRoomId, String name, UUID createdBy) {
//        this();
//        this.setId(chatRoomId);
//        this.name = name;
//        this.createdBy = createdBy;
//    }
//
//    public ChatRoom(UUID chatRoomId, String name, String description, UUID createdBy) {
//        this(chatRoomId, name, createdBy);
//        this.description = description;
//    }
//
//    // Utility methods
//    public void addParticipant(UUID userId) {
//        if (participants.size() < maxParticipants) {
//            participants.add(userId);
//            updateLastActivity();
//        }
//    }
//
//    public void removeParticipant(UUID userId) {
//        participants.remove(userId);
//        updateLastActivity();
//    }
//
//    public boolean hasParticipant(UUID userId) {
//        return participants.contains(userId);
//    }
//
//    public int getParticipantCount() {
//        return participants.size();
//    }
//
//    public void updateLastActivity() {
//        this.lastActivity = Instant.now();
//    }
}