package com.finconsgroup.itserr.marketplace.usercommunication.dm.dto;

import com.fasterxml.jackson.annotation.JsonCreator;
import lombok.Builder;
import lombok.Data;
import lombok.experimental.SuperBuilder;

import java.util.UUID;

@SuperBuilder
@Data
public class OutputConversationMessageSummaryDto {
    private final UUID conversationId;
    private final Long messageCount;

    @Builder.Default
    private Long unreadMessageCount = 0L;
    private OutputChatMessageDto latestMessage;
    private OutputChatMessageDto earliestUnreadMessage;

    @JsonCreator
    public OutputConversationMessageSummaryDto(UUID conversationId, Long messageCount) {
        this.conversationId = conversationId;
        this.messageCount = messageCount;
    }
}
