package com.finconsgroup.itserr.marketplace.usercommunication.dm.component;

import com.finconsgroup.itserr.marketplace.usercommunication.dm.entity.ChatMessage;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.service.ChatMessageService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

import static com.finconsgroup.itserr.marketplace.usercommunication.dm.constant.MessagingType.RABBIT;

@ConditionalOnProperty(value = "type", prefix = "user-communication.dm.messaging", havingValue = RABBIT)
@Component
@RequiredArgsConstructor
@Slf4j
public class ChatMessageConsumer {

    private final ChatMessageService chatMessageService;

    /**
     * Consumes chat messages from the chat queue
     */
    @RabbitListener(queues = "${user-communication.dm.messaging.rabbit.chat.chat-queue}")
    public void receiveChatMessage(ChatMessage message) {
        log.info("Received chat message: {} from user: {} in conversation: {}",
                message.getId(), message.getSenderId(), message.getConversationId());
        chatMessageService.handleChatMessage(message);
    }

    /**
     * Consumes user notification messages
     */
    @RabbitListener(queues = "${user-communication.dm.messaging.rabbit.chat.user-notification-queue}")
    public void receiveUserNotification(ChatMessage notification) {
        log.info("Received user notification: {} for user: {}",
                notification.getId(), notification.getReceiverId());

        // Store notification in the database
        chatMessageService.handleUserNotification(notification);
    }

}
