package com.finconsgroup.itserr.marketplace.usercommunication.dm.bean;

import com.finconsgroup.itserr.marketplace.usercommunication.dm.entity.ChatMessage;
import org.springframework.context.ApplicationEvent;

/**
 * Application event for a chat message.
 */
public class ChatMessageApplicationEvent extends ApplicationEvent {

    private final boolean userNotificationFlag;

    public ChatMessageApplicationEvent(ChatMessage source, boolean userNotificationFlag) {
        super(source);
        this.userNotificationFlag = userNotificationFlag;
    }

    /**
     * Indicates if the message is for user notification.
     *
     * @return {@code true}, if for user notification, {@code false} otherwise.
     */
    public boolean isUserNotification() {
        return userNotificationFlag;
    }

    /**
     * Returns the {@link ChatMessage} source
     *
     * @return ChatMessage
     */
    public ChatMessage getChatMessage() {
        return (ChatMessage) getSource();
    }
}
