/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.usercommunication.dm.entity;

import com.finconsgroup.itserr.marketplace.core.entity.AbstractUUIDEntity;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.entity.ChatMessage;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.entity.MessageReadReceipt;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import jakarta.persistence.UniqueConstraint;
import jakarta.validation.constraints.NotNull;
import java.time.Instant;
import java.util.UUID;
import lombok.Generated;

@Entity
@Table(name="message_read_receipts", uniqueConstraints={@UniqueConstraint(columnNames={"message_id", "user_id"})})
public class MessageReadReceipt
extends AbstractUUIDEntity {
    @NotNull(message="Message ID cannot be blank")
    @ManyToOne(fetch=FetchType.LAZY, optional=false)
    @JoinColumn(name="message_id", nullable=false, insertable=false, updatable=false)
    private @NotNull(message="Message ID cannot be blank") ChatMessage message;
    @Column(name="message_id", updatable=false)
    private UUID messageId;
    @Column(name="user_id", nullable=false)
    @NotNull(message="User ID cannot be blank")
    private @NotNull(message="User ID cannot be blank") UUID userId;
    @Column(name="conversation_id", nullable=false)
    @NotNull(message="Conversation ID cannot be blank")
    private @NotNull(message="Conversation ID cannot be blank") UUID conversationId;
    @Column(name="read_at", nullable=false)
    @NotNull(message="Read timestamp cannot be null")
    private @NotNull(message="Read timestamp cannot be null") Instant readAt;
    @Column(name="created_at", nullable=false)
    private Instant createdAt;

    public void prePersist() {
        super.prePersist();
        this.createdAt = Instant.now();
        this.readAt = Instant.now();
    }

    @Generated
    protected MessageReadReceipt(MessageReadReceiptBuilder<?, ?> b) {
        super(b);
        this.message = b.message;
        this.messageId = b.messageId;
        this.userId = b.userId;
        this.conversationId = b.conversationId;
        this.readAt = b.readAt;
        this.createdAt = b.createdAt;
    }

    @Generated
    public static MessageReadReceiptBuilder<?, ?> builder() {
        return new MessageReadReceiptBuilderImpl();
    }

    @Generated
    public ChatMessage getMessage() {
        return this.message;
    }

    @Generated
    public UUID getMessageId() {
        return this.messageId;
    }

    @Generated
    public UUID getUserId() {
        return this.userId;
    }

    @Generated
    public UUID getConversationId() {
        return this.conversationId;
    }

    @Generated
    public Instant getReadAt() {
        return this.readAt;
    }

    @Generated
    public Instant getCreatedAt() {
        return this.createdAt;
    }

    @Generated
    public void setMessage(ChatMessage message) {
        this.message = message;
    }

    @Generated
    public void setMessageId(UUID messageId) {
        this.messageId = messageId;
    }

    @Generated
    public void setUserId(UUID userId) {
        this.userId = userId;
    }

    @Generated
    public void setConversationId(UUID conversationId) {
        this.conversationId = conversationId;
    }

    @Generated
    public void setReadAt(Instant readAt) {
        this.readAt = readAt;
    }

    @Generated
    public void setCreatedAt(Instant createdAt) {
        this.createdAt = createdAt;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MessageReadReceipt)) {
            return false;
        }
        MessageReadReceipt other = (MessageReadReceipt)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ChatMessage this$message = this.getMessage();
        ChatMessage other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        UUID this$userId = this.getUserId();
        UUID other$userId = other.getUserId();
        return !(this$userId == null ? other$userId != null : !((Object)this$userId).equals(other$userId));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MessageReadReceipt;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        ChatMessage $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        UUID $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : ((Object)$userId).hashCode());
        return result;
    }

    @Generated
    public MessageReadReceipt() {
    }
}

