/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.usercommunication.dm.entity;

import com.finconsgroup.itserr.marketplace.core.entity.AbstractUUIDEntity;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.entity.ConversationParticipant;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.enums.ParticipantRole;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.Table;
import jakarta.persistence.UniqueConstraint;
import jakarta.validation.constraints.NotNull;
import java.time.Instant;
import java.util.UUID;
import lombok.Generated;

@Entity
@Table(name="conversation_participants", uniqueConstraints={@UniqueConstraint(columnNames={"conversation_id", "user_id"})})
public class ConversationParticipant
extends AbstractUUIDEntity {
    @Column(name="conversation_id", nullable=false)
    @NotNull(message="Conversation ID cannot be blank")
    private @NotNull(message="Conversation ID cannot be blank") UUID conversationId;
    @Column(name="user_id", nullable=false)
    @NotNull(message="User ID cannot be blank")
    private @NotNull(message="User ID cannot be blank") UUID userId;
    @Enumerated(value=EnumType.STRING)
    @Column(name="role", nullable=false)
    @NotNull(message="Participant role cannot be null")
    private @NotNull(message="Participant role cannot be null") ParticipantRole role;
    @Column(name="joined_at", nullable=false)
    private Instant joinedAt;
    @Column(name="invited_at")
    private Instant invitedAt;
    @Column(name="invited_by")
    private UUID invitedBy;
    @Column(name="is_active", nullable=false)
    private boolean active;
    @Column(name="is_muted", nullable=false)
    private boolean muted;
    @Column(name="last_read_at")
    private Instant lastReadAt;
    @Column(name="notification_enabled", nullable=false)
    private boolean notificationEnabled;

    public ConversationParticipant(UUID conversationId, UUID userId, ParticipantRole role) {
        this();
        this.conversationId = conversationId;
        this.userId = userId;
        this.role = role;
    }

    public ConversationParticipant(UUID conversationId, UUID userId, ParticipantRole role, UUID invitedBy) {
        this(conversationId, userId, role);
        this.invitedBy = invitedBy;
        this.invitedAt = Instant.now();
    }

    public void prePersist() {
        super.prePersist();
        this.joinedAt = Instant.now();
        this.active = true;
        this.muted = false;
        this.notificationEnabled = true;
    }

    public static ConversationParticipant createOwner(UUID conversationId, UUID userId) {
        return new ConversationParticipant(conversationId, userId, ParticipantRole.OWNER);
    }

    public static ConversationParticipant createMember(UUID conversationId, UUID userId) {
        return new ConversationParticipant(conversationId, userId, ParticipantRole.MEMBER);
    }

    public static ConversationParticipant createInvitedMember(UUID conversationId, UUID userId, UUID invitedBy) {
        return new ConversationParticipant(conversationId, userId, ParticipantRole.MEMBER, invitedBy);
    }

    public static ConversationParticipant createAdmin(UUID conversationId, UUID userId, UUID promotedBy) {
        ConversationParticipant participant = new ConversationParticipant(conversationId, userId, ParticipantRole.ADMIN);
        participant.setInvitedBy(promotedBy);
        return participant;
    }

    public boolean isOwner() {
        return this.role == ParticipantRole.OWNER;
    }

    public boolean isAdmin() {
        return this.role == ParticipantRole.ADMIN;
    }

    public boolean isMember() {
        return this.role == ParticipantRole.MEMBER;
    }

    public boolean hasAdminPrivileges() {
        return this.isOwner() || this.isAdmin();
    }

    public void promoteToAdmin() {
        if (this.isMember()) {
            this.role = ParticipantRole.ADMIN;
        }
    }

    public void demoteToMember() {
        if (this.isAdmin()) {
            this.role = ParticipantRole.MEMBER;
        }
    }

    public void leave() {
        this.active = false;
    }

    public void rejoin() {
        this.active = true;
        this.joinedAt = Instant.now();
    }

    public void markAsRead() {
        this.lastReadAt = Instant.now();
    }

    @Generated
    protected ConversationParticipant(ConversationParticipantBuilder<?, ?> b) {
        super(b);
        this.conversationId = b.conversationId;
        this.userId = b.userId;
        this.role = b.role;
        this.joinedAt = b.joinedAt;
        this.invitedAt = b.invitedAt;
        this.invitedBy = b.invitedBy;
        this.active = b.active;
        this.muted = b.muted;
        this.lastReadAt = b.lastReadAt;
        this.notificationEnabled = b.notificationEnabled;
    }

    @Generated
    public static ConversationParticipantBuilder<?, ?> builder() {
        return new ConversationParticipantBuilderImpl();
    }

    @Generated
    public UUID getConversationId() {
        return this.conversationId;
    }

    @Generated
    public UUID getUserId() {
        return this.userId;
    }

    @Generated
    public ParticipantRole getRole() {
        return this.role;
    }

    @Generated
    public Instant getJoinedAt() {
        return this.joinedAt;
    }

    @Generated
    public Instant getInvitedAt() {
        return this.invitedAt;
    }

    @Generated
    public UUID getInvitedBy() {
        return this.invitedBy;
    }

    @Generated
    public boolean isActive() {
        return this.active;
    }

    @Generated
    public boolean isMuted() {
        return this.muted;
    }

    @Generated
    public Instant getLastReadAt() {
        return this.lastReadAt;
    }

    @Generated
    public boolean isNotificationEnabled() {
        return this.notificationEnabled;
    }

    @Generated
    public void setConversationId(UUID conversationId) {
        this.conversationId = conversationId;
    }

    @Generated
    public void setUserId(UUID userId) {
        this.userId = userId;
    }

    @Generated
    public void setRole(ParticipantRole role) {
        this.role = role;
    }

    @Generated
    public void setJoinedAt(Instant joinedAt) {
        this.joinedAt = joinedAt;
    }

    @Generated
    public void setInvitedAt(Instant invitedAt) {
        this.invitedAt = invitedAt;
    }

    @Generated
    public void setInvitedBy(UUID invitedBy) {
        this.invitedBy = invitedBy;
    }

    @Generated
    public void setActive(boolean active) {
        this.active = active;
    }

    @Generated
    public void setMuted(boolean muted) {
        this.muted = muted;
    }

    @Generated
    public void setLastReadAt(Instant lastReadAt) {
        this.lastReadAt = lastReadAt;
    }

    @Generated
    public void setNotificationEnabled(boolean notificationEnabled) {
        this.notificationEnabled = notificationEnabled;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConversationParticipant)) {
            return false;
        }
        ConversationParticipant other = (ConversationParticipant)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        UUID this$conversationId = this.getConversationId();
        UUID other$conversationId = other.getConversationId();
        if (this$conversationId == null ? other$conversationId != null : !((Object)this$conversationId).equals(other$conversationId)) {
            return false;
        }
        UUID this$userId = this.getUserId();
        UUID other$userId = other.getUserId();
        return !(this$userId == null ? other$userId != null : !((Object)this$userId).equals(other$userId));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ConversationParticipant;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $conversationId = this.getConversationId();
        result = result * 59 + ($conversationId == null ? 43 : ((Object)$conversationId).hashCode());
        UUID $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : ((Object)$userId).hashCode());
        return result;
    }

    @Generated
    public ConversationParticipant() {
    }
}

