/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.usercommunication.dm.entity;

import com.finconsgroup.itserr.marketplace.core.entity.AbstractUUIDEntity;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.entity.ChatMessage;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.entity.MessageReadReceipt;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.enums.MessageType;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import java.time.Instant;
import java.util.List;
import java.util.UUID;
import lombok.Generated;

@Entity
@Table(name="chat_messages")
public class ChatMessage
extends AbstractUUIDEntity {
    @Column(name="sender_id", nullable=false)
    @NotNull(message="Sender ID cannot be blank")
    private @NotNull(message="Sender ID cannot be blank") UUID senderId;
    @Column(name="receiver_id")
    private UUID receiverId;
    @Column(name="content", nullable=false, columnDefinition="TEXT")
    @NotBlank(message="Content cannot be blank")
    private @NotBlank(message="Content cannot be blank") String content;
    @Enumerated(value=EnumType.STRING)
    @Column(name="message_type", nullable=false)
    @NotNull(message="Message type cannot be null")
    private @NotNull(message="Message type cannot be null") MessageType messageType;
    @Column(name="created_at", nullable=false)
    private Instant createdAt;
    @Column(name="conversation_id")
    private UUID conversationId;
    @Column(name="delivered", nullable=false, columnDefinition="BOOLEAN DEFAULT FALSE")
    private boolean delivered;
    @Column(name="delivered_at")
    private Instant deliveredAt;
    @Column(name="read_by_receiver", nullable=false, columnDefinition="BOOLEAN DEFAULT FALSE")
    private boolean readByReceiver;
    @Column(name="read_at")
    private Instant readAt;
    @Column(name="message_index")
    private Long messageIndex;
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.REMOVE}, orphanRemoval=true, mappedBy="message")
    private List<MessageReadReceipt> readReceipts;

    public void setDelivered(boolean delivered) {
        this.delivered = delivered;
        if (delivered && this.deliveredAt == null) {
            this.deliveredAt = Instant.now();
        }
    }

    public void setReadByReceiver(boolean readByReceiver) {
        this.readByReceiver = readByReceiver;
        if (readByReceiver && this.readAt == null) {
            this.readAt = Instant.now();
        }
    }

    public void prePersist() {
        super.prePersist();
        if (this.createdAt == null) {
            this.createdAt = Instant.now();
        }
    }

    @Generated
    protected ChatMessage(ChatMessageBuilder<?, ?> b) {
        super(b);
        this.senderId = b.senderId;
        this.receiverId = b.receiverId;
        this.content = b.content;
        this.messageType = b.messageType;
        this.createdAt = b.createdAt;
        this.conversationId = b.conversationId;
        this.delivered = b.delivered;
        this.deliveredAt = b.deliveredAt;
        this.readByReceiver = b.readByReceiver;
        this.readAt = b.readAt;
        this.messageIndex = b.messageIndex;
        this.readReceipts = b.readReceipts;
    }

    @Generated
    public static ChatMessageBuilder<?, ?> builder() {
        return new ChatMessageBuilderImpl();
    }

    @Generated
    public UUID getSenderId() {
        return this.senderId;
    }

    @Generated
    public UUID getReceiverId() {
        return this.receiverId;
    }

    @Generated
    public String getContent() {
        return this.content;
    }

    @Generated
    public MessageType getMessageType() {
        return this.messageType;
    }

    @Generated
    public Instant getCreatedAt() {
        return this.createdAt;
    }

    @Generated
    public UUID getConversationId() {
        return this.conversationId;
    }

    @Generated
    public boolean isDelivered() {
        return this.delivered;
    }

    @Generated
    public Instant getDeliveredAt() {
        return this.deliveredAt;
    }

    @Generated
    public boolean isReadByReceiver() {
        return this.readByReceiver;
    }

    @Generated
    public Instant getReadAt() {
        return this.readAt;
    }

    @Generated
    public Long getMessageIndex() {
        return this.messageIndex;
    }

    @Generated
    public List<MessageReadReceipt> getReadReceipts() {
        return this.readReceipts;
    }

    @Generated
    public void setSenderId(UUID senderId) {
        this.senderId = senderId;
    }

    @Generated
    public void setReceiverId(UUID receiverId) {
        this.receiverId = receiverId;
    }

    @Generated
    public void setContent(String content) {
        this.content = content;
    }

    @Generated
    public void setMessageType(MessageType messageType) {
        this.messageType = messageType;
    }

    @Generated
    public void setCreatedAt(Instant createdAt) {
        this.createdAt = createdAt;
    }

    @Generated
    public void setConversationId(UUID conversationId) {
        this.conversationId = conversationId;
    }

    @Generated
    public void setDeliveredAt(Instant deliveredAt) {
        this.deliveredAt = deliveredAt;
    }

    @Generated
    public void setReadAt(Instant readAt) {
        this.readAt = readAt;
    }

    @Generated
    public void setMessageIndex(Long messageIndex) {
        this.messageIndex = messageIndex;
    }

    @Generated
    public void setReadReceipts(List<MessageReadReceipt> readReceipts) {
        this.readReceipts = readReceipts;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChatMessage)) {
            return false;
        }
        ChatMessage other = (ChatMessage)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isDelivered() != other.isDelivered()) {
            return false;
        }
        if (this.isReadByReceiver() != other.isReadByReceiver()) {
            return false;
        }
        Long this$messageIndex = this.getMessageIndex();
        Long other$messageIndex = other.getMessageIndex();
        if (this$messageIndex == null ? other$messageIndex != null : !((Object)this$messageIndex).equals(other$messageIndex)) {
            return false;
        }
        UUID this$senderId = this.getSenderId();
        UUID other$senderId = other.getSenderId();
        if (this$senderId == null ? other$senderId != null : !((Object)this$senderId).equals(other$senderId)) {
            return false;
        }
        UUID this$receiverId = this.getReceiverId();
        UUID other$receiverId = other.getReceiverId();
        if (this$receiverId == null ? other$receiverId != null : !((Object)this$receiverId).equals(other$receiverId)) {
            return false;
        }
        String this$content = this.getContent();
        String other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        MessageType this$messageType = this.getMessageType();
        MessageType other$messageType = other.getMessageType();
        if (this$messageType == null ? other$messageType != null : !this$messageType.equals(other$messageType)) {
            return false;
        }
        Instant this$createdAt = this.getCreatedAt();
        Instant other$createdAt = other.getCreatedAt();
        if (this$createdAt == null ? other$createdAt != null : !((Object)this$createdAt).equals(other$createdAt)) {
            return false;
        }
        UUID this$conversationId = this.getConversationId();
        UUID other$conversationId = other.getConversationId();
        if (this$conversationId == null ? other$conversationId != null : !((Object)this$conversationId).equals(other$conversationId)) {
            return false;
        }
        Instant this$deliveredAt = this.getDeliveredAt();
        Instant other$deliveredAt = other.getDeliveredAt();
        if (this$deliveredAt == null ? other$deliveredAt != null : !((Object)this$deliveredAt).equals(other$deliveredAt)) {
            return false;
        }
        Instant this$readAt = this.getReadAt();
        Instant other$readAt = other.getReadAt();
        if (this$readAt == null ? other$readAt != null : !((Object)this$readAt).equals(other$readAt)) {
            return false;
        }
        List this$readReceipts = this.getReadReceipts();
        List other$readReceipts = other.getReadReceipts();
        return !(this$readReceipts == null ? other$readReceipts != null : !((Object)this$readReceipts).equals(other$readReceipts));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ChatMessage;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isDelivered() ? 79 : 97);
        result = result * 59 + (this.isReadByReceiver() ? 79 : 97);
        Long $messageIndex = this.getMessageIndex();
        result = result * 59 + ($messageIndex == null ? 43 : ((Object)$messageIndex).hashCode());
        UUID $senderId = this.getSenderId();
        result = result * 59 + ($senderId == null ? 43 : ((Object)$senderId).hashCode());
        UUID $receiverId = this.getReceiverId();
        result = result * 59 + ($receiverId == null ? 43 : ((Object)$receiverId).hashCode());
        String $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        MessageType $messageType = this.getMessageType();
        result = result * 59 + ($messageType == null ? 43 : $messageType.hashCode());
        Instant $createdAt = this.getCreatedAt();
        result = result * 59 + ($createdAt == null ? 43 : ((Object)$createdAt).hashCode());
        UUID $conversationId = this.getConversationId();
        result = result * 59 + ($conversationId == null ? 43 : ((Object)$conversationId).hashCode());
        Instant $deliveredAt = this.getDeliveredAt();
        result = result * 59 + ($deliveredAt == null ? 43 : ((Object)$deliveredAt).hashCode());
        Instant $readAt = this.getReadAt();
        result = result * 59 + ($readAt == null ? 43 : ((Object)$readAt).hashCode());
        List $readReceipts = this.getReadReceipts();
        result = result * 59 + ($readReceipts == null ? 43 : ((Object)$readReceipts).hashCode());
        return result;
    }

    @Generated
    public ChatMessage() {
    }
}

