/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.usercommunication.dm.controller;

import com.finconsgroup.itserr.marketplace.core.web.exception.WP2ValidationException;
import com.finconsgroup.itserr.marketplace.core.web.security.jwt.JwtTokenHolder;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.api.GroupConversationApi;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.constant.MessageDestinations;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.constant.SecurityConstants;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.dto.InputCreateGroupConversationDto;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.dto.InputInviteUserDto;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.dto.InputPromoteUserDto;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.dto.InputRemoveUserDto;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.entity.ChatMessage;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.entity.Conversation;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.enums.MessageType;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.service.ChatMessageProducer;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.service.GroupConversationService;
import java.time.Instant;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.messaging.simp.SimpMessagingTemplate;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class GroupConversationController
implements GroupConversationApi {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GroupConversationController.class);
    private final GroupConversationService groupConversationService;
    private final ChatMessageProducer messageProducer;
    private final SimpMessagingTemplate messagingTemplate;
    private final MessageDestinations messageDestinations;

    public ResponseEntity<Conversation> createGroupConversation(InputCreateGroupConversationDto request) {
        UUID userId = JwtTokenHolder.getUserIdOrThrow();
        Conversation conversation = this.groupConversationService.createGroupConversation(request.getName(), request.getDescription(), userId);
        log.info("Group conversation created: {}", (Object)conversation.getId());
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)conversation);
    }

    public void inviteUserToGroup(UUID conversationId, InputInviteUserDto request) {
        UUID userId = JwtTokenHolder.getUserIdOrThrow();
        this.groupConversationService.inviteUserToGroup(conversationId, request.getUserId(), userId);
        ChatMessage inviteMessage = new ChatMessage();
        inviteMessage.setId(UUID.randomUUID());
        inviteMessage.setSenderId(SecurityConstants.SYSTEM_USER_ID);
        inviteMessage.setContent(String.valueOf(request.getUserId()) + " was invited to the group");
        inviteMessage.setMessageType(MessageType.SYSTEM);
        inviteMessage.setConversationId(conversationId);
        inviteMessage.setCreatedAt(Instant.now());
        this.messageProducer.sendChatMessage(inviteMessage);
        this.messagingTemplate.convertAndSend((Object)this.messageDestinations.getConversationTopic(conversationId), (Object)inviteMessage);
    }

    public void removeUserFromGroup(UUID conversationId, InputRemoveUserDto request) {
        UUID userId = JwtTokenHolder.getUserIdOrThrow();
        boolean success = this.groupConversationService.removeUserFromGroup(conversationId, request.getUserId(), userId);
        if (!success) {
            throw new WP2ValidationException("Failed to remove user from group");
        }
        ChatMessage removeMessage = new ChatMessage();
        removeMessage.setId(UUID.randomUUID());
        removeMessage.setSenderId(SecurityConstants.SYSTEM_USER_ID);
        removeMessage.setContent(String.valueOf(request.getUserId()) + " was removed from the group");
        removeMessage.setMessageType(MessageType.SYSTEM);
        removeMessage.setConversationId(conversationId);
        removeMessage.setCreatedAt(Instant.now());
        this.messageProducer.sendChatMessage(removeMessage);
        this.messagingTemplate.convertAndSend((Object)this.messageDestinations.getConversationTopic(conversationId), (Object)removeMessage);
    }

    public void promoteUserToAdmin(UUID conversationId, InputPromoteUserDto request) {
        UUID userId = JwtTokenHolder.getUserIdOrThrow();
        this.groupConversationService.promoteUserToAdmin(conversationId, request.getUserId(), userId);
    }

    @Generated
    public GroupConversationController(GroupConversationService groupConversationService, ChatMessageProducer messageProducer, SimpMessagingTemplate messagingTemplate, MessageDestinations messageDestinations) {
        this.groupConversationService = groupConversationService;
        this.messageProducer = messageProducer;
        this.messagingTemplate = messagingTemplate;
        this.messageDestinations = messageDestinations;
    }
}

