/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.usercommunication.dm.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.finconsgroup.itserr.marketplace.core.web.exception.WP2AuthenticationException;
import com.finconsgroup.itserr.marketplace.core.web.exception.WP2AuthorizationException;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.exception.MessagingErrorResponseDto;
import java.nio.charset.StandardCharsets;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.simp.stomp.StompHeaderAccessor;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.web.socket.messaging.StompSubProtocolErrorHandler;

public class WebSocketStompErrorHandler
extends StompSubProtocolErrorHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WebSocketStompErrorHandler.class);
    private final ObjectMapper objectMapper;

    WebSocketStompErrorHandler(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    @NonNull
    protected Message<byte[]> handleInternal(@NonNull StompHeaderAccessor errorHeaderAccessor, @NonNull byte[] errorPayload, Throwable cause, StompHeaderAccessor clientHeaderAccessor) {
        Throwable rootCause;
        byte[] payload = cause != null ? ((rootCause = ExceptionUtils.getRootCause((Throwable)cause)) instanceof WP2AuthenticationException ? this.mapToErrorResponse(401, "ERR_AUTH_401 - Not authenticated", cause, clientHeaderAccessor) : (rootCause instanceof AccessDeniedException || rootCause instanceof WP2AuthorizationException ? this.mapToErrorResponse(403, "ERR_AUTH_403 - Not authorized", cause, clientHeaderAccessor) : this.mapToErrorResponse(500, "ERR_500 - Internal Server Error", cause, clientHeaderAccessor))) : this.mapToErrorResponse(500, "ERR_500 - Internal Server Error", null, clientHeaderAccessor);
        if (errorPayload.length > 0) {
            log.error("Override error payload {} with {}", (Object)errorPayload, (Object)payload);
        }
        return MessageBuilder.createMessage((Object)payload, (MessageHeaders)errorHeaderAccessor.getMessageHeaders());
    }

    private byte[] mapToErrorResponse(int code, String message, Throwable cause, StompHeaderAccessor clientHeaderAccessor) {
        try {
            String destination = clientHeaderAccessor != null ? clientHeaderAccessor.getDestination() : null;
            String requestMessageId = clientHeaderAccessor != null ? clientHeaderAccessor.getFirstNativeHeader("requestMessageId") : null;
            List stackTrace = log.isDebugEnabled() ? ExceptionUtils.getRootCauseStackTraceList((Throwable)cause) : null;
            MessagingErrorResponseDto errorDto = new MessagingErrorResponseDto(code, List.of(message), destination, requestMessageId, stackTrace);
            return this.objectMapper.writeValueAsBytes((Object)errorDto);
        }
        catch (Exception e) {
            log.error("Error converting message to error response", (Throwable)e);
            return ("{\"code\": " + code + ", \"messages\": [\"" + message + "\"] }, \"destination\": \"" + String.valueOf(clientHeaderAccessor) + "\"}").getBytes(StandardCharsets.UTF_8);
        }
    }
}

