/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.usercommunication.dm.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.config.WebSocketStompErrorHandler;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.configuration.properties.WebSocketConfigurationProperties;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.constant.MessageDestinations;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.security.StompOAuth2ClientCredentialsWithRefreshProvider;
import java.util.Optional;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.messaging.simp.config.MessageBrokerRegistry;
import org.springframework.messaging.simp.stomp.StompBrokerRelayMessageHandler;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.web.socket.config.annotation.EnableWebSocketMessageBroker;
import org.springframework.web.socket.config.annotation.StompEndpointRegistry;
import org.springframework.web.socket.config.annotation.WebSocketMessageBrokerConfigurer;
import org.springframework.web.socket.messaging.StompSubProtocolErrorHandler;

@Configuration
@EnableWebSocketMessageBroker
public class WebSocketConfig
implements WebSocketMessageBrokerConfigurer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WebSocketConfig.class);
    private final WebSocketConfigurationProperties webSocketConfigurationProperties;
    private final ObjectMapper objectMapper;
    private final MessageDestinations messageDestinations;

    public void configureMessageBroker(@NonNull MessageBrokerRegistry config) {
        if (this.webSocketConfigurationProperties.isEnableBrokerRelay()) {
            config.enableStompBrokerRelay(new String[]{"/topic", "/queue"}).setSystemHeartbeatSendInterval(10000L).setSystemHeartbeatReceiveInterval(20000L).setTaskScheduler(this.heartBeatScheduler()).setRelayHost(this.webSocketConfigurationProperties.getRelayHost()).setVirtualHost(this.webSocketConfigurationProperties.getRelayVirtualHost()).setRelayPort(this.webSocketConfigurationProperties.getRelayPort()).setClientLogin(this.webSocketConfigurationProperties.getRelayClientLogin()).setClientPasscode(this.webSocketConfigurationProperties.getRelayClientPassword()).setSystemLogin(this.webSocketConfigurationProperties.getRelaySystemLogin()).setSystemPasscode(this.webSocketConfigurationProperties.getRelaySystemPassword()).setUserDestinationBroadcast(this.messageDestinations.getUserDestinationBroadcastTopic()).setUserRegistryBroadcast(this.messageDestinations.getUserRegistryBroadcastTopic());
        } else {
            config.enableSimpleBroker(new String[]{"/topic", "/queue"}).setHeartbeatValue(new long[]{10000L, 20000L}).setTaskScheduler(this.heartBeatScheduler());
        }
        config.setApplicationDestinationPrefixes(new String[]{"/app"});
        config.setUserDestinationPrefix(this.messageDestinations.getUserDestinationPrefix());
    }

    public void registerStompEndpoints(StompEndpointRegistry registry) {
        registry.addEndpoint(new String[]{"/user-communication/sock-ws"}).setAllowedOriginPatterns(new String[]{this.webSocketConfigurationProperties.getCorsAllowedOrigins()}).withSockJS();
        registry.addEndpoint(new String[]{"/user-communication/ws"}).setAllowedOriginPatterns(new String[]{this.webSocketConfigurationProperties.getCorsAllowedOrigins()});
        registry.setErrorHandler((StompSubProtocolErrorHandler)new WebSocketStompErrorHandler(this.objectMapper));
    }

    @Bean
    public TaskScheduler heartBeatScheduler() {
        return new ThreadPoolTaskScheduler();
    }

    @Bean(destroyMethod="shutdown")
    public ScheduledExecutorService oauthTokenRefreshExecutor() {
        return Executors.newSingleThreadScheduledExecutor();
    }

    @Nullable
    @Bean
    public StompOAuth2ClientCredentialsWithRefreshProvider stompOAuth2ClientCredentialsWithRefreshProvider(Optional<StompBrokerRelayMessageHandler> stompBrokerRelayMessageHandlerOptional) {
        if (stompBrokerRelayMessageHandlerOptional.isPresent() && this.webSocketConfigurationProperties.getRelayOauthKeycloakTokenUrl() != null && !this.webSocketConfigurationProperties.getRelayOauthKeycloakTokenUrl().isEmpty()) {
            return new StompOAuth2ClientCredentialsWithRefreshProvider(this.webSocketConfigurationProperties.getRelayOauthKeycloakTokenUrl(), this.webSocketConfigurationProperties.getRelaySystemLogin(), this.webSocketConfigurationProperties.getRelaySystemPassword(), this.webSocketConfigurationProperties.getRelayOauthGrantType(), this.webSocketConfigurationProperties.getRelayOauthParameters(), this.webSocketConfigurationProperties.getRelayOauthRefreshDelay(), this.webSocketConfigurationProperties.getRelayOauthRefreshPeriod(), this.oauthTokenRefreshExecutor(), stompBrokerRelayMessageHandlerOptional.get());
        }
        return null;
    }

    @Generated
    public WebSocketConfig(WebSocketConfigurationProperties webSocketConfigurationProperties, ObjectMapper objectMapper, MessageDestinations messageDestinations) {
        this.webSocketConfigurationProperties = webSocketConfigurationProperties;
        this.objectMapper = objectMapper;
        this.messageDestinations = messageDestinations;
    }
}

