package com.finconsgroup.itserr.marketplace.usercommunication.dm.service;


import com.finconsgroup.itserr.marketplace.usercommunication.dm.dto.InputChatMessageDto;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.dto.InputTypingMessageDto;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.dto.OutputChatMessageDto;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.enums.MessageType;

import java.util.UUID;

/**
 * Service contract for interacting with websockets.
 * Each method is documented to improve generated JavaDoc and maintainability.
 */
public interface WebSocketService {

    /**
     * Handle chat messages sent to a specific conversation
     */
    OutputChatMessageDto sendMessage(UUID userId, UUID conversationId, InputChatMessageDto inputChatMessageDto);

    /**
     * Handle chat messages sent to a specific conversation
     */
    OutputChatMessageDto sendDirectMessage(UUID userId, UUID receiverId, InputChatMessageDto inputChatMessageDto);

    /**
     * Handle typing indicators
     */
    OutputChatMessageDto sendTypingIndicator(UUID userId, UUID conversationId, InputTypingMessageDto inputTypingMessageDto);

    /**
     * Handle user joining a conversation
     */
    OutputChatMessageDto addUser(UUID userId, UUID conversationId, InputChatMessageDto inputChatMessageDto);

    /**
     * Handle user leaving a conversation
     */
    OutputChatMessageDto removeUser(UUID userId, UUID conversationId, InputChatMessageDto inputChatMessageDto);

    /**
     * Broadcast system message to all users in a conversation
     */
    OutputChatMessageDto broadcastSystemMessage(UUID conversationId, String content);

    /**
     * Send notification to a specific user
     */
    OutputChatMessageDto sendUserNotification(UUID userId, String content, MessageType messageType);

    /**
     * Send invitation notification for group chats
     */
    OutputChatMessageDto sendInvitation(UUID userId, UUID conversationId, UUID receiverId);

}
