/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.usercommunication.dm.service.impl;

import com.finconsgroup.itserr.marketplace.usercommunication.dm.constant.SecurityConstants;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.dto.InputChatMessageDto;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.dto.InputTypingMessageDto;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.dto.OutputChatMessageDto;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.dto.OutputConversationDto;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.entity.ChatMessage;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.entity.Conversation;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.enums.MessageType;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.mapper.ChatMessageMapper;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.service.ChatMessageProducer;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.service.ChatMessageService;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.service.ConversationService;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.service.DirectConversationService;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.service.OfflineMessageService;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.service.PreConditionService;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.service.WebSocketService;
import java.time.Instant;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DefaultWebSocketService
implements WebSocketService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultWebSocketService.class);
    private final PreConditionService preConditionService;
    private final ChatMessageProducer messageProducer;
    private final ConversationService conversationService;
    private final DirectConversationService directConversationService;
    private final OfflineMessageService offlineMessageService;
    private final ChatMessageMapper chatMessageMapper;
    private final ChatMessageService chatMessageService;

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public OutputChatMessageDto sendMessage(UUID userId, UUID conversationId, InputChatMessageDto inputChatMessageDto) {
        Conversation conversation = this.preConditionService.checkUserAndConversationAndMessage(userId, conversationId, inputChatMessageDto.getMessageType());
        ChatMessage chatMessage = this.chatMessageMapper.inputChatMessageDtoToEntity(inputChatMessageDto, userId);
        if (chatMessage.getId() == null) {
            chatMessage.setId(UUID.randomUUID());
        }
        chatMessage.setConversationId(conversationId);
        chatMessage.setCreatedAt(Instant.now());
        UUID receiverId = null;
        if (conversation.isDirect()) {
            receiverId = conversation.getOtherParticipantId(userId);
            chatMessage.setReceiverId(receiverId);
        }
        if (receiverId != null) {
            this.offlineMessageService.handleMessageDelivery(chatMessage, receiverId);
            log.debug("Handled offline message delivery to user {} regardless of participant status", (Object)receiverId);
        }
        this.messageProducer.sendChatMessage(chatMessage);
        chatMessage.setDelivered(true);
        log.info("WebSocket message sent to conversation {}: {}", (Object)conversationId, (Object)chatMessage.getId());
        return this.chatMessageService.getOutputChatMessageDto(chatMessage, false);
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public OutputChatMessageDto sendDirectMessage(UUID userId, UUID receiverId, InputChatMessageDto inputChatMessageDto) {
        if (userId == null || receiverId == null) {
            log.warn("Direct message missing sender or receiver ID");
            return null;
        }
        ChatMessage chatMessage = this.chatMessageMapper.inputChatMessageDtoToEntity(inputChatMessageDto, userId);
        chatMessage.setReceiverId(receiverId);
        OutputConversationDto conversationDto = this.directConversationService.createOrGetDirectConversation(userId, receiverId);
        chatMessage.setId(UUID.randomUUID());
        chatMessage.setConversationId(conversationDto.getId());
        chatMessage.setCreatedAt(Instant.now());
        this.messageProducer.sendChatMessage(chatMessage);
        return this.chatMessageService.getOutputChatMessageDto(chatMessage, false);
    }

    public OutputChatMessageDto sendTypingIndicator(UUID userId, UUID conversationId, InputTypingMessageDto inputTypingMessageDto) {
        this.preConditionService.checkUserAndConversation(userId, conversationId);
        ChatMessage chatMessage = new ChatMessage();
        chatMessage.setConversationId(conversationId);
        chatMessage.setSenderId(userId);
        chatMessage.setContent(inputTypingMessageDto.getContent());
        chatMessage.setMessageType(MessageType.TYPING);
        chatMessage.setCreatedAt(Instant.now());
        log.debug("Typing indicator sent for user {} in conversation {}", (Object)userId, (Object)conversationId);
        return this.chatMessageService.getOutputChatMessageDto(chatMessage, false);
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public OutputChatMessageDto addUser(UUID userId, UUID conversationId, InputChatMessageDto inputChatMessageDto) {
        Conversation conversation = this.preConditionService.checkConversation(conversationId);
        ChatMessage chatMessage = this.chatMessageMapper.inputChatMessageDtoToEntity(inputChatMessageDto, userId);
        if (!conversation.isDirect() && conversation.isGroup() && conversation.isPrivateFlag() && !this.conversationService.isUserParticipant(conversationId, userId)) {
            log.warn("User {} attempted to join private group {} without invitation", (Object)userId, (Object)conversationId);
            return null;
        }
        chatMessage.setId(UUID.randomUUID());
        chatMessage.setMessageType(MessageType.JOIN);
        chatMessage.setConversationId(conversationId);
        chatMessage.setContent(String.valueOf(userId) + " joined the conversation");
        chatMessage.setCreatedAt(Instant.now());
        this.messageProducer.sendChatMessage(chatMessage);
        log.info("User {} joined conversation {} via WebSocket", (Object)userId, (Object)conversationId);
        return this.chatMessageService.getOutputChatMessageDto(chatMessage, false);
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public OutputChatMessageDto removeUser(UUID userId, UUID conversationId, InputChatMessageDto inputChatMessageDto) {
        this.preConditionService.checkUserAndConversation(userId, conversationId);
        ChatMessage chatMessage = this.chatMessageMapper.inputChatMessageDtoToEntity(inputChatMessageDto, userId);
        this.conversationService.leaveConversation(conversationId, userId);
        chatMessage.setId(UUID.randomUUID());
        chatMessage.setMessageType(MessageType.LEAVE);
        chatMessage.setConversationId(conversationId);
        chatMessage.setContent(String.valueOf(userId) + " left the conversation");
        chatMessage.setCreatedAt(Instant.now());
        this.messageProducer.sendChatMessage(chatMessage);
        log.info("User {} left conversation {} via WebSocket", (Object)userId, (Object)conversationId);
        return this.chatMessageService.getOutputChatMessageDto(chatMessage, false);
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public OutputChatMessageDto broadcastSystemMessage(UUID conversationId, String content) {
        ChatMessage systemMessage = new ChatMessage();
        systemMessage.setId(UUID.randomUUID());
        systemMessage.setSenderId(SecurityConstants.SYSTEM_USER_ID);
        systemMessage.setContent(content);
        systemMessage.setMessageType(MessageType.SYSTEM);
        systemMessage.setConversationId(conversationId);
        systemMessage.setCreatedAt(Instant.now());
        this.messageProducer.sendChatMessage(systemMessage);
        return this.chatMessageService.getOutputChatMessageDto(systemMessage, false);
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public OutputChatMessageDto sendUserNotification(UUID userId, String content, MessageType messageType) {
        ChatMessage notification = new ChatMessage();
        notification.setId(UUID.randomUUID());
        notification.setSenderId(SecurityConstants.SYSTEM_USER_ID);
        notification.setReceiverId(userId);
        notification.setContent(content);
        notification.setMessageType(messageType);
        notification.setCreatedAt(Instant.now());
        this.messageProducer.sendUserNotification(userId, content, messageType);
        return this.chatMessageService.getOutputChatMessageDto(notification, false);
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public OutputChatMessageDto sendInvitation(UUID userId, UUID conversationId, UUID receiverId) {
        Conversation conversation = this.preConditionService.checkConversation(conversationId);
        String content = String.format("You have been invited to join '%s' by %s", conversation.getName(), userId);
        ChatMessage inviteNotification = new ChatMessage();
        inviteNotification.setId(UUID.randomUUID());
        inviteNotification.setSenderId(userId);
        inviteNotification.setReceiverId(receiverId);
        inviteNotification.setContent(content);
        inviteNotification.setMessageType(MessageType.NOTIFICATION);
        inviteNotification.setConversationId(conversationId);
        inviteNotification.setCreatedAt(Instant.now());
        this.messageProducer.sendUserNotification(receiverId, content, MessageType.NOTIFICATION);
        return this.chatMessageService.getOutputChatMessageDto(inviteNotification, false);
    }

    @Generated
    public DefaultWebSocketService(PreConditionService preConditionService, ChatMessageProducer messageProducer, ConversationService conversationService, DirectConversationService directConversationService, OfflineMessageService offlineMessageService, ChatMessageMapper chatMessageMapper, ChatMessageService chatMessageService) {
        this.preConditionService = preConditionService;
        this.messageProducer = messageProducer;
        this.conversationService = conversationService;
        this.directConversationService = directConversationService;
        this.offlineMessageService = offlineMessageService;
        this.chatMessageMapper = chatMessageMapper;
        this.chatMessageService = chatMessageService;
    }
}

