/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.usercommunication.dm.service.impl;

import com.finconsgroup.itserr.marketplace.usercommunication.dm.entity.User;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.repository.UserRepository;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.security.WebSocketUser;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.service.impl.AbstractSessionManagementService;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@ConditionalOnProperty(prefix="user-communication.dm.web-socket", value={"enable-broker-relay"}, havingValue="false", matchIfMissing=true)
@Service
public class DefaultSessionManagementService
extends AbstractSessionManagementService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultSessionManagementService.class);
    private final Map<UUID, Set<String>> sessionIdsByUserId = new ConcurrentHashMap();
    private final Map<String, WebSocketUser> userBySessionId = new ConcurrentHashMap();

    public DefaultSessionManagementService(UserRepository userRepository) {
        super(userRepository);
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public User onSessionCreated(@NonNull String sessionId, @NonNull WebSocketUser user) {
        UUID userId = user.getUserId();
        boolean isFirstSession = !this.sessionIdsByUserId.containsKey(userId);
        AtomicInteger sessionCount = new AtomicInteger(0);
        this.userBySessionId.put(sessionId, user);
        this.sessionIdsByUserId.merge(userId, new HashSet<String>(List.of(sessionId)), (s1, s2) -> {
            s1.addAll(s2);
            sessionCount.set(s1.size());
            return s1;
        });
        if (isFirstSession) {
            log.info("User {} came online with session {}", (Object)userId, (Object)sessionId);
            return this.updateUserOnlineStatus(user, true);
        }
        log.info("User {} (session: {}, total sessions: {})", new Object[]{userId, sessionId, sessionCount.get()});
        return null;
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public User onSessionDestroyed(@NonNull String sessionId) {
        WebSocketUser user = (WebSocketUser)this.userBySessionId.remove(sessionId);
        if (user != null) {
            UUID userId = user.getUserId();
            AtomicBoolean isLastSession = new AtomicBoolean(false);
            AtomicInteger sessionCount = new AtomicInteger(0);
            this.sessionIdsByUserId.computeIfPresent(userId, (key, sessions) -> {
                sessions.remove(sessionId);
                isLastSession.set(sessions.isEmpty());
                sessionCount.set(sessions.size());
                return sessions;
            });
            if (isLastSession.get()) {
                this.sessionIdsByUserId.remove(userId);
                log.info("User {} went offline (session: {})", (Object)userId, (Object)sessionId);
                return this.updateUserOnlineStatus(user, false);
            }
            log.info("User {} disconnected session {} (remaining sessions: {})", new Object[]{userId, sessionId, sessionCount.get()});
        }
        return null;
    }

    public boolean isUserOnline(@NonNull UUID userId) {
        return this.getUserSessionCount(userId) > 0;
    }

    public int getUserSessionCount(@NonNull UUID userId) {
        return Optional.ofNullable((Set)this.sessionIdsByUserId.get(userId)).map(Set::size).orElse(0);
    }
}

