/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.usercommunication.dm.service.impl;

import com.finconsgroup.itserr.marketplace.core.entity.AbstractUUIDEntity;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.component.ConversationHelper;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.constant.MessageDestinations;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.constant.SecurityConstants;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.dto.OutputChatMessageDto;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.dto.OutputChatMessageReadReceiptDto;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.dto.OutputConversationDto;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.dto.OutputConversationMessageSummaryDto;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.dto.OutputUserDto;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.entity.ChatMessage;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.entity.Conversation;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.entity.MessageReadReceipt;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.enums.ConversationType;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.mapper.ChatMessageMapper;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.mapper.MessageReadReceiptMapper;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.repository.ChatMessageRepository;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.repository.ConversationRepository;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.repository.MessageReadReceiptRepository;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.service.ChatMessageService;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.service.ChatRoomService;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.service.impl.ChatMessageServiceImpl;
import jakarta.persistence.EntityManager;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.lang.NonNull;
import org.springframework.messaging.simp.SimpMessagingTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ChatMessageServiceImpl
implements ChatMessageService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ChatMessageServiceImpl.class);
    private final ChatMessageRepository chatMessageRepository;
    private final ChatRoomService chatRoomService;
    private final ChatMessageMapper chatMessageMapper;
    private final MessageReadReceiptRepository messageReadReceiptRepository;
    private final MessageReadReceiptMapper messageReadReceiptMapper;
    private final ConversationRepository conversationRepository;
    private final ConversationHelper conversationHelper;
    private final EntityManager entityManager;
    private final SimpMessagingTemplate messagingTemplate;
    private final MessageDestinations messageDestinations;

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void handleChatMessage(ChatMessage message) {
        try {
            switch (1.$SwitchMap$com$finconsgroup$itserr$marketplace$usercommunication$dm$enums$MessageType[message.getMessageType().ordinal()]) {
                case 1: {
                    this.handleTextMessage(message);
                    break;
                }
                case 2: {
                    this.handleTypingMessage(message);
                    break;
                }
                case 3: {
                    this.handleSystemMessage(message);
                    break;
                }
                case 4: 
                case 5: {
                    this.handleMediaMessage(message);
                    break;
                }
                default: {
                    log.warn("Unknown message type: {} for message: {}", (Object)message.getMessageType(), (Object)message.getId());
                }
            }
            log.info("Chat message processed successfully: {}", (Object)message.getId());
        }
        catch (Exception e) {
            log.error("Failed to process chat message: {}", (Object)message.getId(), (Object)e);
        }
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void handleUserNotification(ChatMessage notification) {
        try {
            this.chatMessageRepository.save((Object)notification);
            log.info("User notification processed successfully: {}", (Object)notification.getId());
        }
        catch (Exception e) {
            log.error("Failed to process user notification: {}", (Object)notification.getId(), (Object)e);
        }
    }

    @Transactional(propagation=Propagation.REQUIRED, readOnly=true, noRollbackFor={Exception.class})
    public List<ChatMessage> getConversationMessages(UUID conversationId) {
        return this.chatMessageRepository.findByConversationIdOrderByCreatedAtAsc(conversationId);
    }

    @Transactional(propagation=Propagation.REQUIRED, readOnly=true, noRollbackFor={Exception.class})
    public Page<OutputChatMessageDto> getConversationMessages(Conversation conversation, Pageable pageable) {
        Page chatMessagesPage = this.chatMessageRepository.findMessagesByConversationId(conversation.getId(), pageable);
        List chatMessageDtos = this.mapToOutputChatMessageDtos(chatMessagesPage.getContent(), List.of(conversation));
        return new PageImpl(chatMessageDtos, chatMessagesPage.getPageable(), chatMessagesPage.getTotalElements());
    }

    public int markConversationAsRead(Conversation conversation, UUID userId, Instant readAt) {
        if (conversation.isDirect()) {
            List markedMessageIds = this.chatMessageRepository.getConversationMessagesToMarkAsRead(conversation.getId(), userId, readAt);
            this.markDirectMessagesAsRead(conversation, readAt, markedMessageIds);
            return markedMessageIds.size();
        }
        List markedMessageIds = this.messageReadReceiptRepository.getAllMessagesToMarkAsReadByUser(userId, conversation.getId());
        this.markGroupMessagesAsRead(conversation, userId, readAt, markedMessageIds);
        return markedMessageIds.size();
    }

    public int markConversationMessagesUptoCreatedAtAsRead(Conversation conversation, UUID userId, Instant readAt, Instant uptoCreatedAt) {
        if (conversation.isDirect()) {
            List markedMessageIds = this.chatMessageRepository.getConversationMessagesUptoCreatedAtToMarkAsRead(conversation.getId(), uptoCreatedAt, userId, readAt);
            this.markDirectMessagesAsRead(conversation, readAt, markedMessageIds);
            return markedMessageIds.size();
        }
        List markedMessageIds = this.messageReadReceiptRepository.getMessagesUptoCreatedAtToMarkAsReadByUser(userId, conversation.getId(), uptoCreatedAt);
        this.markGroupMessagesAsRead(conversation, userId, readAt, markedMessageIds);
        return markedMessageIds.size();
    }

    public int markConversationBulkMessagesAsRead(Conversation conversation, UUID userId, Instant readAt, Set<UUID> messageIds) {
        if (conversation.isDirect()) {
            List markedMessageIds = this.chatMessageRepository.getConversationMessagesByIdInToMarkAsRead(conversation.getId(), messageIds, userId, readAt);
            this.markDirectMessagesAsRead(conversation, readAt, markedMessageIds);
            return markedMessageIds.size();
        }
        List markedMessageIds = this.messageReadReceiptRepository.getMessagesByIdInToMarkAsReadByUser(userId, conversation.getId(), messageIds);
        this.markGroupMessagesAsRead(conversation, userId, readAt, markedMessageIds);
        return markedMessageIds.size();
    }

    private void markDirectMessagesAsRead(Conversation conversation, Instant readAt, List<UUID> messageIds) {
        if (messageIds == null || messageIds.isEmpty()) {
            return;
        }
        try {
            int messageCount = messageIds.size();
            int batchSize = 20;
            int offset = 0;
            int batchCount = Math.ceilDiv(messageCount, 20);
            for (int i = 0; i < batchCount; ++i) {
                List<UUID> batchMessageIds = messageIds.subList(offset, Math.min(offset + 20, messageCount));
                List chatMessages = this.chatMessageRepository.findMessagesByConversationIdAndIdIn(conversation.getId(), batchMessageIds);
                ArrayList<ChatMessage> savedChatMessages = new ArrayList<ChatMessage>(messageCount);
                for (ChatMessage chatMessage : chatMessages) {
                    chatMessage.setReadByReceiver(true);
                    chatMessage.setReadAt(readAt);
                    savedChatMessages.add((ChatMessage)this.chatMessageRepository.saveAndFlush((Object)chatMessage));
                }
                List chatMessageDtos = this.mapToOutputChatMessageDtos(savedChatMessages, List.of(conversation));
                for (OutputChatMessageDto chatMessageDto : chatMessageDtos) {
                    this.messagingTemplate.convertAndSend((Object)this.messageDestinations.getConversationTopic(conversation.getId()), (Object)chatMessageDto);
                }
            }
        }
        catch (Exception e) {
            log.warn("Failed to send direct message read receipts for message ids - {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private void markGroupMessagesAsRead(Conversation conversation, UUID userId, Instant readAt, List<UUID> messageIds) {
        if (messageIds == null || messageIds.isEmpty()) {
            return;
        }
        try {
            int messageCount = messageIds.size();
            int batchSize = 20;
            int offset = 0;
            int batchCount = Math.ceilDiv(messageCount, 20);
            for (int i = 0; i < batchCount; ++i) {
                List<UUID> batchMessageIds = messageIds.subList(offset, Math.min(offset + 20, messageCount));
                List chatMessages = this.chatMessageRepository.findMessagesByConversationIdAndIdIn(conversation.getId(), batchMessageIds);
                for (ChatMessage chatMessage : chatMessages) {
                    MessageReadReceipt messageReadReceipt = new MessageReadReceipt();
                    messageReadReceipt.setConversationId(conversation.getId());
                    messageReadReceipt.setMessageId(chatMessage.getId());
                    messageReadReceipt.setUserId(userId);
                    messageReadReceipt.setCreatedAt(readAt);
                    messageReadReceipt.setReadAt(readAt);
                    this.messageReadReceiptRepository.saveAndFlush((Object)messageReadReceipt);
                }
                List chatMessageDtos = this.mapToOutputChatMessageDtos(chatMessages, List.of(conversation));
                for (OutputChatMessageDto chatMessageDto : chatMessageDtos) {
                    this.messagingTemplate.convertAndSend((Object)this.messageDestinations.getConversationTopic(conversation.getId()), (Object)chatMessageDto);
                }
            }
        }
        catch (Exception e) {
            log.warn("Failed to send group message read receipts for message ids - {}", (Object)e.getMessage(), (Object)e);
        }
    }

    @Transactional(propagation=Propagation.REQUIRED, readOnly=true, noRollbackFor={Exception.class})
    public Map<UUID, OutputConversationMessageSummaryDto> getConversationMessageSummary(UUID userId, List<Conversation> conversations) {
        if (conversations == null || conversations.isEmpty()) {
            return Map.of();
        }
        HashSet conversationIds = new HashSet();
        HashSet directConversationIds = new HashSet();
        HashSet groupConversationIds = new HashSet();
        conversations.forEach(conversation -> {
            conversationIds.add(conversation.getId());
            if (conversation.isDirect()) {
                directConversationIds.add(conversation.getId());
            } else if (conversation.isGroup()) {
                groupConversationIds.add(conversation.getId());
            }
        });
        Map messageSummaryByConversationId = this.chatMessageRepository.countByConversationId(conversationIds).stream().collect(Collectors.toMap(OutputConversationMessageSummaryDto::getConversationId, Function.identity()));
        List latestChatMessages = this.chatMessageRepository.findLatestByConversationIdIn(conversationIds);
        LinkedList earliestUnreadChatMessages = new LinkedList();
        HashMap<UUID, Long> unreadCountByConversationId = new HashMap<UUID, Long>();
        if (!directConversationIds.isEmpty()) {
            unreadCountByConversationId.putAll(this.chatMessageRepository.countUnreadByConversationIdIn(userId, directConversationIds).stream().collect(Collectors.toMap(OutputConversationMessageSummaryDto::getConversationId, OutputConversationMessageSummaryDto::getMessageCount)));
            earliestUnreadChatMessages.addAll(this.chatMessageRepository.findEarliestUnreadByConversationIdIn(userId, directConversationIds));
        }
        if (!groupConversationIds.isEmpty()) {
            unreadCountByConversationId.putAll(this.messageReadReceiptRepository.countUnreadByConversationIdIn(userId, groupConversationIds).stream().collect(Collectors.toMap(OutputConversationMessageSummaryDto::getConversationId, OutputConversationMessageSummaryDto::getMessageCount)));
            earliestUnreadChatMessages.addAll(this.messageReadReceiptRepository.findEarliestUnreadByConversationIdIn(userId, groupConversationIds));
        }
        HashMap chatMessageById = new HashMap();
        HashMap latestChatMessageByConversationId = new HashMap();
        HashMap earliestUnreadChatMessageByConversationId = new HashMap();
        latestChatMessages.forEach(chatMessage -> {
            chatMessageById.put(chatMessage.getId(), chatMessage);
            latestChatMessageByConversationId.put(chatMessage.getConversationId(), chatMessage.getId());
        });
        earliestUnreadChatMessages.forEach(chatMessage -> {
            chatMessageById.put(chatMessage.getId(), chatMessage);
            earliestUnreadChatMessageByConversationId.put(chatMessage.getConversationId(), chatMessage.getId());
        });
        List chatMessageDtos = this.mapToOutputChatMessageDtos(List.copyOf(chatMessageById.values()), conversations);
        Map chatMessageDtoById = chatMessageDtos.stream().collect(Collectors.toMap(OutputChatMessageDto::getId, Function.identity()));
        return conversationIds.stream().collect(Collectors.toMap(Function.identity(), conversationId -> {
            UUID earliestMessageId;
            OutputConversationMessageSummaryDto messageSummaryDto = (OutputConversationMessageSummaryDto)messageSummaryByConversationId.get(conversationId);
            if (messageSummaryDto == null) {
                return new OutputConversationMessageSummaryDto(conversationId, Long.valueOf(0L));
            }
            messageSummaryDto.setUnreadMessageCount(unreadCountByConversationId.getOrDefault(conversationId, 0L));
            UUID latestMessageId = (UUID)latestChatMessageByConversationId.get(conversationId);
            if (latestMessageId != null) {
                messageSummaryDto.setLatestMessage((OutputChatMessageDto)chatMessageDtoById.get(latestMessageId));
            }
            if ((earliestMessageId = (UUID)earliestUnreadChatMessageByConversationId.get(conversationId)) != null) {
                messageSummaryDto.setEarliestUnreadMessage((OutputChatMessageDto)chatMessageDtoById.get(earliestMessageId));
            }
            return messageSummaryDto;
        }));
    }

    private List<OutputChatMessageDto> mapToOutputChatMessageDtos(@NonNull List<ChatMessage> chatMessages, @NonNull List<Conversation> conversations) {
        Set chatUserIds = chatMessages.stream().map(ChatMessage::getSenderId).collect(Collectors.toSet());
        Map userDtoById = this.conversationHelper.mapUserIdsToDtos(chatUserIds, true);
        Map conversationDtoById = conversations.stream().collect(Collectors.toMap(AbstractUUIDEntity::getId, Function.identity()));
        HashSet groupChatMessageIds = new HashSet();
        LinkedList<OutputChatMessageDto> chatMessageDtos = new LinkedList<OutputChatMessageDto>();
        chatMessages.forEach(chatMessage -> {
            OutputChatMessageDto chatMessageDto = this.chatMessageMapper.entityToOutputChatMessageDto(chatMessage);
            chatMessageDto.setSender((OutputUserDto)userDtoById.get(chatMessage.getSenderId()));
            Conversation conversation = (Conversation)conversationDtoById.get(chatMessage.getConversationId());
            if (conversation.getConversationType() == ConversationType.GROUP) {
                groupChatMessageIds.add(chatMessage.getId());
            } else if (conversation.getConversationType() == ConversationType.DIRECT && chatMessage.getReadAt() != null) {
                chatMessageDto.setReadReceipts(List.of(OutputChatMessageReadReceiptDto.builder().id(chatMessage.getId()).userId(chatMessage.getReceiverId()).readAt(chatMessage.getReadAt()).createdAt(chatMessage.getReadAt()).build()));
            }
            chatMessageDtos.add(chatMessageDto);
        });
        this.populateGroupReadReceipts(chatMessageDtos, groupChatMessageIds);
        return chatMessageDtos;
    }

    private void populateGroupReadReceipts(List<OutputChatMessageDto> chatMessageDtos, Set<UUID> groupChatMessageIds) {
        if (groupChatMessageIds.isEmpty()) {
            return;
        }
        Map messageReadReceiptsByMessageId = this.messageReadReceiptRepository.findByMessageIdIn(groupChatMessageIds).stream().collect(Collectors.groupingBy(mrr -> mrr.getMessage().getId(), Collectors.mapping(Function.identity(), Collectors.toList())));
        chatMessageDtos.forEach(chatMessageDto -> chatMessageDto.setReadReceipts((List)Optional.ofNullable((List)messageReadReceiptsByMessageId.get(chatMessageDto.getId())).map(mrr -> mrr.stream().map(arg_0 -> ((MessageReadReceiptMapper)this.messageReadReceiptMapper).entityToOutputChatMessageReadReceiptDto(arg_0)).collect(Collectors.toList())).orElse(null)));
    }

    @Transactional(propagation=Propagation.REQUIRED, readOnly=true, noRollbackFor={Exception.class})
    public List<ChatMessage> getUserNotifications(UUID userId) {
        return this.chatMessageRepository.findBySenderIdOrderByCreatedAtDesc(SecurityConstants.SYSTEM_USER_ID).stream().filter(msg -> userId.equals(msg.getReceiverId())).toList();
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void clearUserNotifications(UUID userId) {
        List notifications = this.getUserNotifications(userId);
        this.chatMessageRepository.deleteAll((Iterable)notifications);
        log.info("Cleared {} notifications for user: {}", (Object)notifications.size(), (Object)userId);
    }

    @Transactional(propagation=Propagation.REQUIRED, readOnly=true, noRollbackFor={Exception.class})
    public Page<OutputChatMessageDto> searchMessages(UUID userId, String searchTerm, Pageable pageable) {
        Page chatMessageDtoPage = this.chatMessageRepository.findByContentContainingIgnoreCase(userId, searchTerm, pageable).map(arg_0 -> ((ChatMessageMapper)this.chatMessageMapper).entityToOutputChatMessageDto(arg_0));
        HashSet chatMessageIds = new HashSet();
        HashSet conversationIds = new HashSet();
        HashSet chatUserIds = new HashSet();
        chatMessageDtoPage.forEach(chatMessageDto -> {
            chatMessageIds.add(chatMessageDto.getId());
            conversationIds.add(chatMessageDto.getConversationId());
            chatUserIds.add(chatMessageDto.getSenderId());
        });
        if (!chatMessageIds.isEmpty()) {
            Map conversationDtoById = this.conversationHelper.loadConversations(userId, conversationIds).stream().collect(Collectors.toMap(OutputConversationDto::getId, Function.identity()));
            Map userDtoById = this.conversationHelper.mapUserIdsToDtos(chatUserIds, true);
            chatMessageDtoPage.getContent().forEach(chatMessageDto -> {
                OutputConversationDto conversationDto = (OutputConversationDto)conversationDtoById.get(chatMessageDto.getConversationId());
                if (conversationDto != null) {
                    chatMessageDto.setConversationName(conversationDto.getName());
                }
                chatMessageDto.setSender((OutputUserDto)userDtoById.get(chatMessageDto.getSenderId()));
            });
        }
        return chatMessageDtoPage;
    }

    public OutputChatMessageDto getOutputChatMessageDto(@NonNull ChatMessage chatMessage, boolean loadUserProfiles) {
        OutputChatMessageDto chatMessageDto = this.chatMessageMapper.entityToOutputChatMessageDto(chatMessage);
        if (!SecurityConstants.SYSTEM_USER_ID.equals(chatMessage.getSenderId())) {
            OutputUserDto sender = (OutputUserDto)this.conversationHelper.mapUserIdsToDtos(Set.of(chatMessage.getSenderId()), loadUserProfiles).get(chatMessageDto.getSenderId());
            chatMessageDto.setSender(sender);
        }
        return chatMessageDto;
    }

    private void handleTextMessage(ChatMessage message) {
        UUID conversationId = message.getConversationId();
        if (conversationId != null) {
            this.saveChatMessage(message);
            this.conversationRepository.updateLastActivity(conversationId, Instant.now());
        }
        log.debug("Text message stored and marked as delivered for conversation: {}", (Object)conversationId);
    }

    private void handleTypingMessage(ChatMessage message) {
        log.debug("Typing indicator from user: {} in conversation: {}", (Object)message.getSenderId(), (Object)message.getConversationId());
    }

    private void handleSystemMessage(ChatMessage message) {
        UUID conversationId = message.getConversationId();
        if (conversationId != null) {
            this.saveChatMessage(message);
            this.chatMessageRepository.findById(message.getId()).ifPresent(chatMessage -> message.setMessageIndex(chatMessage.getMessageIndex()));
        }
        log.info("System message processed and marked as delivered for conversation: {}", (Object)conversationId);
    }

    private void handleMediaMessage(ChatMessage message) {
        UUID conversationId = message.getConversationId();
        if (conversationId != null) {
            this.saveChatMessage(message);
            this.conversationRepository.updateLastActivity(conversationId, Instant.now());
        }
        log.info("Media message processed and marked as delivered: {} in conversation: {}", (Object)message.getMessageType(), (Object)conversationId);
    }

    private void saveChatMessage(ChatMessage message) {
        message.setDelivered(true);
        ChatMessage savedMessage = (ChatMessage)this.chatMessageRepository.saveAndFlush((Object)message);
        int updateCount = this.chatMessageRepository.updateMessageIndex(message.getConversationId());
        log.debug("message index updated for row: {}", (Object)updateCount);
        if (updateCount > 0) {
            this.entityManager.refresh((Object)savedMessage);
            message.setMessageIndex(savedMessage.getMessageIndex());
        }
    }

    @Generated
    public ChatMessageServiceImpl(ChatMessageRepository chatMessageRepository, ChatRoomService chatRoomService, ChatMessageMapper chatMessageMapper, MessageReadReceiptRepository messageReadReceiptRepository, MessageReadReceiptMapper messageReadReceiptMapper, ConversationRepository conversationRepository, ConversationHelper conversationHelper, EntityManager entityManager, SimpMessagingTemplate messagingTemplate, MessageDestinations messageDestinations) {
        this.chatMessageRepository = chatMessageRepository;
        this.chatRoomService = chatRoomService;
        this.chatMessageMapper = chatMessageMapper;
        this.messageReadReceiptRepository = messageReadReceiptRepository;
        this.messageReadReceiptMapper = messageReadReceiptMapper;
        this.conversationRepository = conversationRepository;
        this.conversationHelper = conversationHelper;
        this.entityManager = entityManager;
        this.messagingTemplate = messagingTemplate;
        this.messageDestinations = messageDestinations;
    }
}

