/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.usercommunication.dm.security;

import com.finconsgroup.itserr.marketplace.core.web.exception.WP2AuthenticationException;
import com.finconsgroup.itserr.marketplace.core.web.security.jwt.JwtTokenHolder;
import com.finconsgroup.itserr.marketplace.core.web.security.jwt.JwtTokenVerifier;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.security.WebSocketAuthentication;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.security.WebSocketUser;
import io.micrometer.common.util.StringUtils;
import java.security.Principal;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.simp.stomp.StompCommand;
import org.springframework.messaging.simp.stomp.StompHeaderAccessor;
import org.springframework.messaging.support.ChannelInterceptor;
import org.springframework.messaging.support.MessageHeaderAccessor;
import org.springframework.security.core.authority.SimpleGrantedAuthority;

public final class AuthenticationChannelInterceptor
implements ChannelInterceptor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AuthenticationChannelInterceptor.class);
    private final String securityAudience;
    private final JwtTokenVerifier jwtTokenVerifier;

    public Message<?> preSend(@NonNull Message<?> message, @NonNull MessageChannel channel) {
        StompHeaderAccessor accessor = (StompHeaderAccessor)MessageHeaderAccessor.getAccessor(message, StompHeaderAccessor.class);
        if (accessor != null && StompCommand.CONNECT.equals((Object)accessor.getCommand())) {
            String token = accessor.getFirstNativeHeader("token");
            WebSocketAuthentication authentication = this.mapTokenToAuthentication(token);
            accessor.removeNativeHeader("token");
            if (authentication != null) {
                accessor.setUser((Principal)authentication);
                return message;
            }
            throw new WP2AuthenticationException();
        }
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WebSocketAuthentication mapTokenToAuthentication(String token) {
        try {
            if (StringUtils.isNotBlank((String)token)) {
                JwtTokenHolder.setToken((String)token, (JwtTokenVerifier)this.jwtTokenVerifier);
                Optional userId = JwtTokenHolder.getUserId();
                if (userId.isPresent()) {
                    log.info("user id - {}", userId.get());
                    WebSocketUser user = WebSocketUser.builder().userId((UUID)userId.get()).displayName(JwtTokenHolder.getNameOrThrow()).firstName(JwtTokenHolder.getGivenNameOrThrow()).lastName(JwtTokenHolder.getFamilyNameOrThrow()).build();
                    Set authorities = JwtTokenHolder.getRoles((String)this.securityAudience).stream().map(SimpleGrantedAuthority::new).collect(Collectors.toSet());
                    WebSocketAuthentication webSocketAuthentication = new WebSocketAuthentication(user, authorities);
                    return webSocketAuthentication;
                }
            }
            WebSocketAuthentication webSocketAuthentication = null;
            return webSocketAuthentication;
        }
        finally {
            JwtTokenHolder.setToken(null);
        }
    }

    @Generated
    public AuthenticationChannelInterceptor(String securityAudience, JwtTokenVerifier jwtTokenVerifier) {
        this.securityAudience = securityAudience;
        this.jwtTokenVerifier = jwtTokenVerifier;
    }
}

