/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.usercommunication.dm.repository;

import com.finconsgroup.itserr.marketplace.usercommunication.dm.dto.OutputConversationMessageSummaryDto;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.entity.ChatMessage;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.entity.MessageReadReceipt;
import java.time.Instant;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface MessageReadReceiptRepository
extends JpaRepository<MessageReadReceipt, UUID> {
    public List<MessageReadReceipt> findByMessageIdIn(Set<UUID> var1);

    @Modifying
    @Query(value="SELECT cm.id\nFROM chat_messages cm\nWHERE cm.conversation_id = :conversationId\nAND cm.sender_id != :userId\nAND NOT EXISTS (SELECT 1 FROM message_read_receipts mrr WHERE mrr.message_id = cm.id AND mrr.user_id = :userId)\n", nativeQuery=true)
    public List<UUID> getAllMessagesToMarkAsReadByUser(@Param(value="userId") UUID var1, @Param(value="conversationId") UUID var2);

    @Modifying
    @Query(value="INSERT INTO message_read_receipts (message_id, user_id, conversation_id, read_at, created_at)\nSELECT cm.id, :userId, :conversationId, :readAt, :readAt\nFROM chat_messages cm\nWHERE cm.conversation_id = :conversationId\nAND cm.sender_id != :userId\nAND NOT EXISTS (SELECT 1 FROM message_read_receipts mrr WHERE mrr.message_id = cm.id AND mrr.user_id = :userId)\n", nativeQuery=true)
    public int markAllMessagesAsReadByUser(@Param(value="userId") UUID var1, @Param(value="conversationId") UUID var2, @Param(value="readAt") Instant var3);

    @Modifying
    @Query(value="SELECT cm.id\nFROM chat_messages cm\nWHERE cm.conversation_id = :conversationId\nAND cm.sender_id != :userId\nAND cm.created_at <= :uptoCreatedAt\nAND NOT EXISTS (SELECT 1 FROM message_read_receipts mrr WHERE mrr.message_id = cm.id AND mrr.user_id = :userId)\n", nativeQuery=true)
    public List<UUID> getMessagesUptoCreatedAtToMarkAsReadByUser(@Param(value="userId") UUID var1, @Param(value="conversationId") UUID var2, @Param(value="uptoCreatedAt") Instant var3);

    @Modifying
    @Query(value="INSERT INTO message_read_receipts (message_id, user_id, conversation_id, read_at, created_at)\nSELECT cm.id, :userId, :conversationId, :readAt, :readAt\nFROM chat_messages cm\nWHERE cm.conversation_id = :conversationId\nAND cm.sender_id != :userId\nAND cm.created_at <= :uptoCreatedAt\nAND NOT EXISTS (SELECT 1 FROM message_read_receipts mrr WHERE mrr.message_id = cm.id AND mrr.user_id = :userId)\n", nativeQuery=true)
    public int markMessagesUptoCreatedAtAsReadByUser(@Param(value="userId") UUID var1, @Param(value="conversationId") UUID var2, @Param(value="uptoCreatedAt") Instant var3, @Param(value="readAt") Instant var4);

    @Query(value="SELECT cm.id\nFROM chat_messages cm\nWHERE cm.conversation_id = :conversationId\nAND cm.sender_id != :userId\nAND cm.id IN (:ids)\nAND NOT EXISTS (SELECT 1 FROM message_read_receipts mrr WHERE mrr.message_id = cm.id AND mrr.user_id = :userId)\n", nativeQuery=true)
    public List<UUID> getMessagesByIdInToMarkAsReadByUser(@Param(value="userId") UUID var1, @Param(value="conversationId") UUID var2, @Param(value="ids") Set<UUID> var3);

    @Modifying
    @Query(value="INSERT INTO message_read_receipts (message_id, user_id, conversation_id, read_at, created_at)\nSELECT cm.id, :userId, :conversationId, :readAt, :readAt\nFROM chat_messages cm\nWHERE cm.conversation_id = :conversationId\nAND cm.sender_id != :userId\nAND cm.id IN (:ids)\nAND NOT EXISTS (SELECT 1 FROM message_read_receipts mrr WHERE mrr.message_id = cm.id AND mrr.user_id = :userId)\n", nativeQuery=true)
    public int markMessagesByIdInAsReadByUser(@Param(value="userId") UUID var1, @Param(value="conversationId") UUID var2, @Param(value="ids") Set<UUID> var3, @Param(value="readAt") Instant var4);

    @Query(value="        SELECT new com.finconsgroup.itserr.marketplace.usercommunication.dm.dto.OutputConversationMessageSummaryDto(cm.conversationId, count(cm))\n        FROM ChatMessage cm\n        LEFT JOIN MessageReadReceipt mrr ON mrr.messageId = cm.id AND mrr.userId = :userId\n        WHERE cm.conversationId IN (:conversationIds)\n        AND cm.senderId <> :userId\n        AND mrr.id IS NULL\n")
    public List<OutputConversationMessageSummaryDto> countUnreadByConversationIdIn(@Param(value="userId") UUID var1, @Param(value="conversationIds") Set<UUID> var2);

    @Query(value="        WITH messages AS (SELECT cm.*,\n        rank() OVER (PARTITION BY cm.conversation_id ORDER by cm.created_at) message_rank\n        FROM chat_messages cm\n        left join message_read_receipts mrr on mrr.message_id = cm.id and mrr.user_id = :userId\n        WHERE cm.conversation_id IN (:conversationIds)\n        AND cm.sender_id <> :userId\n        AND mrr.id IS NULL)\n        SELECT messages.* FROM messages WHERE message_rank = 1\n", nativeQuery=true)
    public List<ChatMessage> findEarliestUnreadByConversationIdIn(@Param(value="userId") UUID var1, @Param(value="conversationIds") Set<UUID> var2);
}

