/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.usercommunication.dm.entity;

import com.finconsgroup.itserr.marketplace.core.entity.AbstractUUIDEntity;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.entity.OfflineMessage;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.enums.MessageType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.Table;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import java.time.Instant;
import java.time.LocalDateTime;
import java.util.UUID;
import lombok.Generated;

@Entity
@Table(name="offline_messages")
public class OfflineMessage
extends AbstractUUIDEntity {
    @Column(name="message_id", nullable=false)
    @NotNull(message="Message ID cannot be blank")
    private @NotNull(message="Message ID cannot be blank") UUID messageId;
    @Column(name="recipient_user_id", nullable=false)
    @NotNull(message="Recipient user ID cannot be blank")
    private @NotNull(message="Recipient user ID cannot be blank") UUID recipientUserId;
    @Column(name="conversation_id", nullable=false)
    @NotNull(message="Conversation ID cannot be blank")
    private @NotNull(message="Conversation ID cannot be blank") UUID conversationId;
    @Column(name="sender_id", nullable=false)
    @NotNull(message="Sender ID cannot be blank")
    private @NotNull(message="Sender ID cannot be blank") UUID senderId;
    @Column(name="content", nullable=false, columnDefinition="TEXT")
    @NotBlank(message="Content cannot be blank")
    private @NotBlank(message="Content cannot be blank") String content;
    @Enumerated(value=EnumType.STRING)
    @Column(name="message_type", nullable=false)
    @NotNull(message="Message type cannot be null")
    private @NotNull(message="Message type cannot be null") MessageType messageType;
    @Column(name="created_at", nullable=false)
    private Instant createdAt;
    @Column(name="queued_at", nullable=false)
    private LocalDateTime queuedAt;
    @Column(name="delivered", nullable=false)
    private boolean delivered;
    @Column(name="delivered_at")
    private LocalDateTime deliveredAt;

    public OfflineMessage(UUID messageId, UUID recipientUserId, UUID conversationId, UUID senderId, String content, MessageType messageType, Instant createdAt) {
        this();
        this.messageId = messageId;
        this.recipientUserId = recipientUserId;
        this.conversationId = conversationId;
        this.senderId = senderId;
        this.content = content;
        this.messageType = messageType;
        this.createdAt = createdAt;
    }

    public void setDelivered(boolean delivered) {
        this.delivered = delivered;
        if (delivered && this.deliveredAt == null) {
            this.deliveredAt = LocalDateTime.now();
        }
    }

    public void prePersist() {
        super.prePersist();
        this.queuedAt = LocalDateTime.now();
    }

    @Generated
    protected OfflineMessage(OfflineMessageBuilder<?, ?> b) {
        super(b);
        this.messageId = b.messageId;
        this.recipientUserId = b.recipientUserId;
        this.conversationId = b.conversationId;
        this.senderId = b.senderId;
        this.content = b.content;
        this.messageType = b.messageType;
        this.createdAt = b.createdAt;
        this.queuedAt = b.queuedAt;
        this.delivered = b.delivered;
        this.deliveredAt = b.deliveredAt;
    }

    @Generated
    public static OfflineMessageBuilder<?, ?> builder() {
        return new OfflineMessageBuilderImpl();
    }

    @Generated
    public UUID getMessageId() {
        return this.messageId;
    }

    @Generated
    public UUID getRecipientUserId() {
        return this.recipientUserId;
    }

    @Generated
    public UUID getConversationId() {
        return this.conversationId;
    }

    @Generated
    public UUID getSenderId() {
        return this.senderId;
    }

    @Generated
    public String getContent() {
        return this.content;
    }

    @Generated
    public MessageType getMessageType() {
        return this.messageType;
    }

    @Generated
    public Instant getCreatedAt() {
        return this.createdAt;
    }

    @Generated
    public LocalDateTime getQueuedAt() {
        return this.queuedAt;
    }

    @Generated
    public boolean isDelivered() {
        return this.delivered;
    }

    @Generated
    public LocalDateTime getDeliveredAt() {
        return this.deliveredAt;
    }

    @Generated
    public void setMessageId(UUID messageId) {
        this.messageId = messageId;
    }

    @Generated
    public void setRecipientUserId(UUID recipientUserId) {
        this.recipientUserId = recipientUserId;
    }

    @Generated
    public void setConversationId(UUID conversationId) {
        this.conversationId = conversationId;
    }

    @Generated
    public void setSenderId(UUID senderId) {
        this.senderId = senderId;
    }

    @Generated
    public void setContent(String content) {
        this.content = content;
    }

    @Generated
    public void setMessageType(MessageType messageType) {
        this.messageType = messageType;
    }

    @Generated
    public void setCreatedAt(Instant createdAt) {
        this.createdAt = createdAt;
    }

    @Generated
    public void setQueuedAt(LocalDateTime queuedAt) {
        this.queuedAt = queuedAt;
    }

    @Generated
    public void setDeliveredAt(LocalDateTime deliveredAt) {
        this.deliveredAt = deliveredAt;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OfflineMessage)) {
            return false;
        }
        OfflineMessage other = (OfflineMessage)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        UUID this$messageId = this.getMessageId();
        UUID other$messageId = other.getMessageId();
        if (this$messageId == null ? other$messageId != null : !((Object)this$messageId).equals(other$messageId)) {
            return false;
        }
        UUID this$recipientUserId = this.getRecipientUserId();
        UUID other$recipientUserId = other.getRecipientUserId();
        return !(this$recipientUserId == null ? other$recipientUserId != null : !((Object)this$recipientUserId).equals(other$recipientUserId));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof OfflineMessage;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        UUID $messageId = this.getMessageId();
        result = result * 59 + ($messageId == null ? 43 : ((Object)$messageId).hashCode());
        UUID $recipientUserId = this.getRecipientUserId();
        result = result * 59 + ($recipientUserId == null ? 43 : ((Object)$recipientUserId).hashCode());
        return result;
    }

    @Generated
    public OfflineMessage() {
    }
}

