/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.usercommunication.dm.controller;

import com.finconsgroup.itserr.marketplace.core.web.security.jwt.JwtTokenHolder;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.api.UserApi;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.entity.User;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.repository.UserRepository;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class UserController
implements UserApi {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UserController.class);
    private final UserRepository userRepository;

    public ResponseEntity<List<User>> getOnlineUsers() {
        try {
            List onlineUsers = this.userRepository.findByOnlineTrue();
            log.info("Retrieved {} online users", (Object)onlineUsers.size());
            return ResponseEntity.ok((Object)onlineUsers);
        }
        catch (Exception e) {
            log.error("Error retrieving online users", (Throwable)e);
            return ResponseEntity.internalServerError().build();
        }
    }

    public ResponseEntity<List<User>> getRecentlyActiveUsers() {
        try {
            Instant oneHourAgo = Instant.now().minus(1L, ChronoUnit.HOURS);
            List recentUsers = this.userRepository.findRecentlyActiveUsers(oneHourAgo);
            log.info("Retrieved {} recently active users", (Object)recentUsers.size());
            return ResponseEntity.ok((Object)recentUsers);
        }
        catch (Exception e) {
            log.error("Error retrieving recently active users", (Throwable)e);
            return ResponseEntity.internalServerError().build();
        }
    }

    public ResponseEntity<User> getUserById(UUID userId) {
        Optional user = this.userRepository.findById(userId);
        if (user.isPresent()) {
            return ResponseEntity.ok((Object)((User)user.get()));
        }
        log.warn("User not found with userId: {}", (Object)userId);
        return ResponseEntity.notFound().build();
    }

    public ResponseEntity<String> updateUserStatus(boolean online) {
        UUID userId = JwtTokenHolder.getUserIdOrThrow();
        this.userRepository.updateOnlineStatus(userId, online, Instant.now());
        log.info("Updated online status for user {} to {}", (Object)userId, (Object)online);
        return ResponseEntity.ok((Object)"User status updated successfully");
    }

    @Generated
    public UserController(UserRepository userRepository) {
        this.userRepository = userRepository;
    }
}

