/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.usercommunication.dm.controller;

import com.finconsgroup.itserr.marketplace.core.web.security.jwt.JwtTokenHolder;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.api.ConversationApi;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.dto.InputBulkMessagesDto;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.dto.InputMuteConversationDto;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.dto.OutputChatMessageDto;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.dto.OutputConversationDto;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.dto.OutputConversationParticipantDto;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.dto.OutputConversationStatsDto;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.dto.OutputSearchResultDto;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.dto.OutputUnreadMessageSummaryDto;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.service.ConversationService;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.service.OfflineMessageService;
import java.util.List;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class ConversationController
implements ConversationApi {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConversationController.class);
    private final ConversationService conversationService;
    private final OfflineMessageService offlineMessageService;

    public OutputConversationDto getConversationById(UUID conversationId) {
        UUID userId = JwtTokenHolder.getUserIdOrThrow();
        return this.conversationService.getConversation(userId, conversationId);
    }

    public Page<OutputConversationDto> getRecentConversationsForUser(int pageNumber, int pageSize, String sort, Sort.Direction direction) {
        UUID userId = JwtTokenHolder.getUserIdOrThrow();
        PageRequest pageable = PageRequest.of((int)pageNumber, (int)pageSize, (Sort)Sort.by((Sort.Direction)direction, (String[])new String[]{sort}));
        return this.conversationService.getRecentConversationsForUser(userId, (Pageable)pageable);
    }

    public List<OutputConversationParticipantDto> getConversationParticipants(UUID conversationId) {
        return this.conversationService.getConversationParticipants(conversationId);
    }

    public void leaveConversation(UUID conversationId) {
        UUID userId = JwtTokenHolder.getUserIdOrThrow();
        this.conversationService.leaveConversation(conversationId, userId);
    }

    public void muteConversation(UUID conversationId, InputMuteConversationDto request) {
        UUID userId = JwtTokenHolder.getUserIdOrThrow();
        this.conversationService.muteConversation(conversationId, userId, request.isMuted());
    }

    public void markConversationAsRead(UUID conversationId) {
        UUID userId = JwtTokenHolder.getUserIdOrThrow();
        this.conversationService.markConversationAsRead(userId, conversationId);
    }

    public void markConversationUptoMessageAsRead(UUID conversationId, UUID messageId) {
        UUID userId = JwtTokenHolder.getUserIdOrThrow();
        this.conversationService.markConversationUptoMessageAsRead(userId, conversationId, messageId);
    }

    public void markBulkMessagesAsRead(UUID conversationId, InputBulkMessagesDto request) {
        UUID userId = JwtTokenHolder.getUserIdOrThrow();
        this.conversationService.markBulkMessagesAsRead(userId, conversationId, request);
    }

    public OutputSearchResultDto searchConversations(String query, int pageNumber, int pageSize, String sort, Sort.Direction direction) {
        UUID userId = JwtTokenHolder.getUserIdOrThrow();
        PageRequest pageable = PageRequest.of((int)pageNumber, (int)pageSize, (Sort)Sort.by((Sort.Direction)direction, (String[])new String[]{sort}));
        return this.conversationService.searchConversations(userId, query, (Pageable)pageable);
    }

    public OutputConversationStatsDto getConversationStats() {
        return this.conversationService.getConversationStats();
    }

    public Page<OutputChatMessageDto> getConversationMessages(UUID conversationId, int pageNumber, int pageSize, String sort, Sort.Direction direction) {
        UUID userId = JwtTokenHolder.getUserIdOrThrow();
        PageRequest pageable = PageRequest.of((int)pageNumber, (int)pageSize, (Sort)Sort.by((Sort.Direction)direction, (String[])new String[]{sort}));
        return this.conversationService.getConversationMessages(userId, conversationId, (Pageable)pageable);
    }

    public OutputUnreadMessageSummaryDto getUnreadMessageSummary() {
        UUID userId = JwtTokenHolder.getUserIdOrThrow();
        return this.offlineMessageService.getUnreadMessageSummary(userId);
    }

    @Generated
    public ConversationController(ConversationService conversationService, OfflineMessageService offlineMessageService) {
        this.conversationService = conversationService;
        this.offlineMessageService = offlineMessageService;
    }
}

