/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.usercommunication.dm.config;

import com.finconsgroup.itserr.marketplace.usercommunication.dm.configuration.properties.RabbitMQMessagingClientProperties;
import com.rabbitmq.client.impl.CredentialsProvider;
import com.rabbitmq.client.impl.CredentialsRefreshService;
import com.rabbitmq.client.impl.DefaultCredentialsProvider;
import com.rabbitmq.client.impl.DefaultCredentialsRefreshService;
import com.rabbitmq.client.impl.OAuth2ClientCredentialsGrantCredentialsProvider;
import java.time.Duration;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.springframework.amqp.core.Binding;
import org.springframework.amqp.core.BindingBuilder;
import org.springframework.amqp.core.Queue;
import org.springframework.amqp.core.QueueBuilder;
import org.springframework.amqp.core.TopicExchange;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.amqp.support.converter.Jackson2JsonMessageConverter;
import org.springframework.amqp.support.converter.MessageConverter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(value={"type"}, prefix="user-communication.dm.messaging", havingValue="RABBIT")
public class RabbitMQConfig {
    @Bean
    public TopicExchange chatExchange(RabbitMQMessagingClientProperties rabbitMQMessagingClientProperties) {
        return new TopicExchange(rabbitMQMessagingClientProperties.getChat().getExchange());
    }

    @Bean
    public Queue chatQueue(RabbitMQMessagingClientProperties rabbitMQMessagingClientProperties) {
        return QueueBuilder.durable((String)rabbitMQMessagingClientProperties.getChat().getChatQueue()).build();
    }

    @Bean
    public Queue userNotificationQueue(RabbitMQMessagingClientProperties rabbitMQMessagingClientProperties) {
        return QueueBuilder.durable((String)rabbitMQMessagingClientProperties.getChat().getUserNotificationQueue()).build();
    }

    @Bean
    public Binding chatBinding(RabbitMQMessagingClientProperties rabbitMQMessagingClientProperties) {
        return BindingBuilder.bind((Queue)this.chatQueue(rabbitMQMessagingClientProperties)).to(this.chatExchange(rabbitMQMessagingClientProperties)).with(rabbitMQMessagingClientProperties.getChat().getChatRoutingKey());
    }

    @Bean
    public Binding userNotificationBinding(RabbitMQMessagingClientProperties rabbitMQMessagingClientProperties) {
        return BindingBuilder.bind((Queue)this.userNotificationQueue(rabbitMQMessagingClientProperties)).to(this.chatExchange(rabbitMQMessagingClientProperties)).with(rabbitMQMessagingClientProperties.getChat().getUserNotificationRoutingKey());
    }

    @Bean
    public MessageConverter jsonMessageConverter() {
        return new Jackson2JsonMessageConverter();
    }

    @Bean
    public RabbitTemplate rabbitTemplate(ConnectionFactory connectionFactory) {
        RabbitTemplate rabbitTemplate = new RabbitTemplate(connectionFactory);
        rabbitTemplate.setMessageConverter(this.jsonMessageConverter());
        return rabbitTemplate;
    }

    @Bean
    public CredentialsProvider credentialsProvider(RabbitMQMessagingClientProperties rabbitMQMessagingClientProperties) {
        if (StringUtils.isBlank((CharSequence)rabbitMQMessagingClientProperties.getKeycloakTokenUrl())) {
            return this.createDefaultCredentialsProvider(rabbitMQMessagingClientProperties);
        }
        return this.createOAuthCredentialsProvider(rabbitMQMessagingClientProperties);
    }

    private CredentialsProvider createDefaultCredentialsProvider(RabbitMQMessagingClientProperties rabbitMQMessagingClientProperties) {
        return new DefaultCredentialsProvider(rabbitMQMessagingClientProperties.getUsername(), rabbitMQMessagingClientProperties.getPassword());
    }

    private CredentialsProvider createOAuthCredentialsProvider(RabbitMQMessagingClientProperties rabbitMQMessagingClientProperties) {
        OAuth2ClientCredentialsGrantCredentialsProvider.OAuth2ClientCredentialsGrantCredentialsProviderBuilder credentialsProviderBuilder = new OAuth2ClientCredentialsGrantCredentialsProvider.OAuth2ClientCredentialsGrantCredentialsProviderBuilder().clientId(rabbitMQMessagingClientProperties.getUsername()).clientSecret(rabbitMQMessagingClientProperties.getPassword()).tokenEndpointUri(rabbitMQMessagingClientProperties.getKeycloakTokenUrl()).grantType(rabbitMQMessagingClientProperties.getGrantType());
        if (rabbitMQMessagingClientProperties.getOauthParameters() != null) {
            rabbitMQMessagingClientProperties.getOauthParameters().forEach((arg_0, arg_1) -> ((OAuth2ClientCredentialsGrantCredentialsProvider.OAuth2ClientCredentialsGrantCredentialsProviderBuilder)credentialsProviderBuilder).parameter(arg_0, arg_1));
        }
        return credentialsProviderBuilder.build();
    }

    @Bean
    public CredentialsRefreshService credentialsRefreshService(RabbitMQMessagingClientProperties rabbitMQMessagingClientProperties) {
        if (StringUtils.isBlank((CharSequence)rabbitMQMessagingClientProperties.getKeycloakTokenUrl())) {
            return null;
        }
        Function refreshDelayStrategy = DefaultCredentialsRefreshService.fixedDelayBeforeExpirationRefreshDelayStrategy((Duration)Duration.ofSeconds(20L));
        return new DefaultCredentialsRefreshService.DefaultCredentialsRefreshServiceBuilder().refreshDelayStrategy(refreshDelayStrategy).build();
    }
}

