/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.usercommunication.dm.component;

import com.finconsgroup.itserr.marketplace.core.web.dto.OutputPageDto;
import com.finconsgroup.itserr.marketplace.core.web.enums.SortDirection;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.client.UserProfileDmClient;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.client.dto.userprofile.InputFindUserProfilesByIdsDto;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.client.dto.userprofile.OutputUserProfileDmDto;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.dto.OutputConversationDto;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.dto.OutputUserDto;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.entity.Conversation;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.entity.User;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.mapper.ConversationMapper;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.mapper.UserMapper;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.repository.ConversationRepository;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.repository.UserRepository;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Component
public class ConversationHelper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConversationHelper.class);
    private final ConversationRepository conversationRepository;
    private final ConversationMapper conversationMapper;
    private final UserRepository userRepository;
    private final UserMapper userMapper;
    private final UserProfileDmClient userProfileDmClient;

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void saveConversationUsers(Set<UUID> userIds) {
        Map userProfileDtoById = this.loadUserProfiles(userIds);
        Map userById = this.loadChatUsers(userIds, Function.identity());
        userProfileDtoById.values().forEach(userProfileDmDto -> {
            try {
                User existingUser = (User)userById.get(userProfileDmDto.getId());
                if (existingUser != null) {
                    existingUser.setFirstName(userProfileDmDto.getFirstName());
                    existingUser.setLastName(userProfileDmDto.getLastName());
                    this.userRepository.saveAndFlush((Object)existingUser);
                } else {
                    User newUser = this.userMapper.userProfileDmDtoToEntity(userProfileDmDto);
                    newUser.setLastSeen(null);
                    this.userRepository.saveAndFlush((Object)newUser);
                }
            }
            catch (Exception e) {
                log.error("Failed to save conversation user: {}", (Object)userProfileDmDto.getId(), (Object)e);
            }
        });
    }

    @Transactional(propagation=Propagation.REQUIRED, readOnly=true, noRollbackFor={Exception.class})
    @NonNull
    public List<OutputConversationDto> loadConversations(@NonNull UUID userId, @NonNull Set<UUID> conversationIds) {
        List conversations = this.conversationRepository.findAllById(conversationIds);
        return this.populateDetailsForDirect(userId, conversations);
    }

    @Transactional(propagation=Propagation.REQUIRED, readOnly=true, noRollbackFor={Exception.class})
    @NonNull
    public List<OutputConversationDto> populateDetailsForDirect(@NonNull UUID userId, @NonNull List<Conversation> conversations) {
        LinkedList<OutputConversationDto> conversationDtos = new LinkedList<OutputConversationDto>();
        LinkedHashSet<UUID> directConversationOtherUserIds = new LinkedHashSet<UUID>();
        directConversationOtherUserIds.add(userId);
        conversations.forEach(conversation -> {
            OutputConversationDto conversationDto = this.conversationMapper.entityToOutputConversationDto(conversation);
            conversationDtos.add(conversationDto);
            if (conversation.isDirect()) {
                UUID otherUserId = conversation.getOtherParticipantId(userId);
                conversationDto.setName(otherUserId.toString());
                directConversationOtherUserIds.add(otherUserId);
            }
        });
        this.populateDetailsForDirect(conversationDtos, directConversationOtherUserIds);
        return conversationDtos;
    }

    @Transactional(propagation=Propagation.REQUIRED, readOnly=true, noRollbackFor={Exception.class})
    @NonNull
    public OutputConversationDto populateDetailsForDirect(@NonNull UUID userId, @NonNull Conversation conversation) {
        List conversationDtos = this.populateDetailsForDirect(userId, List.of(conversation));
        return (OutputConversationDto)conversationDtos.getFirst();
    }

    @Transactional(propagation=Propagation.REQUIRED, readOnly=true, noRollbackFor={Exception.class})
    public void populateDetailsForDirect(@NonNull List<OutputConversationDto> conversationDtos, @NonNull Set<UUID> directConversationUserIds) {
        if (directConversationUserIds.isEmpty()) {
            return;
        }
        Map userDtoById = this.mapUserIdsToDtos(directConversationUserIds, true);
        conversationDtos.forEach(conversationDto -> {
            UUID receiverId = UUID.fromString(conversationDto.getName());
            OutputUserDto userDto = (OutputUserDto)userDtoById.get(receiverId);
            if (userDto != null) {
                conversationDto.setName(userDto.getFirstName() + " " + userDto.getLastName());
            }
            conversationDto.setReceiver(userDto);
            conversationDto.setCreatedByUser((OutputUserDto)userDtoById.get(conversationDto.getCreatedBy()));
        });
    }

    @NonNull
    public Map<UUID, OutputUserDto> mapUserIdsToDtos(@NonNull Set<UUID> userIds, boolean loadUserProfiles) {
        if (userIds.isEmpty()) {
            return Map.of();
        }
        Map userProfileDtoById = loadUserProfiles ? this.loadUserProfiles(userIds) : Map.of();
        Map userDtoById = this.loadChatUsers(userIds);
        for (UUID userId : userIds) {
            OutputUserProfileDmDto userProfileDto = (OutputUserProfileDmDto)userProfileDtoById.get(userId);
            OutputUserDto userDto = (OutputUserDto)userDtoById.get(userId);
            if (userProfileDto == null) continue;
            if (userDto == null) {
                userDto = this.userMapper.userProfileDmDtoToOutputUserDto(userProfileDto);
                userDtoById.put(userId, userDto);
                continue;
            }
            userDto.setImageUrl(userProfileDto.getImageUrl());
        }
        return userDtoById;
    }

    @NonNull
    private Map<UUID, OutputUserDto> loadChatUsers(@NonNull Set<UUID> userIds) {
        return this.loadChatUsers(userIds, arg_0 -> ((UserMapper)this.userMapper).entityToOutputUserDto(arg_0));
    }

    @NonNull
    private <T> Map<UUID, T> loadChatUsers(@NonNull Set<UUID> userIds, @NonNull Function<User, T> mapper) {
        HashMap mappedUserById = new HashMap();
        try {
            this.userRepository.findAllById(userIds).forEach(user -> mappedUserById.put(user.getId(), mapper.apply((User)user)));
        }
        catch (Exception e) {
            log.error("Error loading chat users", (Throwable)e);
        }
        return mappedUserById;
    }

    @NonNull
    private Map<UUID, OutputUserProfileDmDto> loadUserProfiles(@NonNull Set<UUID> userProfileIds) {
        if (userProfileIds.isEmpty()) {
            return Map.of();
        }
        HashMap<UUID, OutputUserProfileDmDto> userProfileDmDtoById = new HashMap<UUID, OutputUserProfileDmDto>();
        try {
            InputFindUserProfilesByIdsDto inputFindUserProfilesByIdsDto = InputFindUserProfilesByIdsDto.builder().ids(new ArrayList<UUID>(userProfileIds)).build();
            OutputPageDto userOutputProfileDmPageDto = this.userProfileDmClient.findAllByIds(inputFindUserProfilesByIdsDto, 0, userProfileIds.size(), "id", SortDirection.ASC);
            userOutputProfileDmPageDto.getContent().forEach(outputUserProfileDmDto -> userProfileDmDtoById.put(outputUserProfileDmDto.getId(), (OutputUserProfileDmDto)outputUserProfileDmDto));
        }
        catch (Exception e) {
            log.error("Error loading user profiles", (Throwable)e);
        }
        return userProfileDmDtoById;
    }

    @Generated
    public ConversationHelper(ConversationRepository conversationRepository, ConversationMapper conversationMapper, UserRepository userRepository, UserMapper userMapper, UserProfileDmClient userProfileDmClient) {
        this.conversationRepository = conversationRepository;
        this.conversationMapper = conversationMapper;
        this.userRepository = userRepository;
        this.userMapper = userMapper;
        this.userProfileDmClient = userProfileDmClient;
    }
}

