package com.finconsgroup.itserr.marketplace.usercommunication.dm.service.impl;

import com.finconsgroup.itserr.marketplace.usercommunication.dm.entity.ChatMessage;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.service.MessagingService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Service;

import static com.finconsgroup.itserr.marketplace.usercommunication.dm.constant.MessagingType.LOGGER;

/**
 * Implementation for {@link MessagingService} that simply logs the messages to standard output.
 */
@Service
@ConditionalOnProperty(value = "type", prefix = "user-communication.dm.messaging", havingValue = LOGGER,
        matchIfMissing = true)
@Slf4j
public class LoggerMessagingService implements MessagingService {

    @Override
    public void sendChatMessage(@NonNull ChatMessage chatMessage) {
        log.info("Sending chat message : {}", chatMessage);
    }

    @Override
    public void sendUserNotification(@NonNull ChatMessage notification) {
        log.info("Sending user notification : {}", notification);
    }
}
