package com.finconsgroup.itserr.marketplace.usercommunication.dm.service.impl;

import com.finconsgroup.itserr.marketplace.usercommunication.dm.service.ChatRoomService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/**
 * Service implementation for chat room management and user presence in rooms.
 */
@Service
@Transactional
@RequiredArgsConstructor
@Slf4j
public class ChatRoomServiceImpl implements ChatRoomService {
    // TODO: Check Later as this feature is not a priority for now

//    private final ChatRoomRepository chatRoomRepository;
//    private final UserRepository userRepository;
//
//    @Override
//    public ChatRoom createChatRoom(String name, String description, UUID createdBy) {
//        UUID chatRoomId = UUID.randomUUID();
//        ChatRoom chatRoom = new ChatRoom(chatRoomId, name, description, createdBy);
//        chatRoom = chatRoomRepository.save(chatRoom);
//        log.info("Created new chat room: {} with ID: {}", name, chatRoomId);
//        return chatRoom;
//    }
//
//    @Override
//    public Optional<ChatRoom> getChatRoom(UUID chatRoomId) {
//        return chatRoomRepository.findByChatRoomId(chatRoomId);
//    }
//
//    @Override
//    public List<ChatRoom> getAllActiveChatRooms() {
//        return chatRoomRepository.findByActiveTrue();
//    }
//
//    @Override
//    public List<ChatRoom> getChatRoomsForUser(UUID userId) {
//        return chatRoomRepository.findByParticipantsContainingAndActiveTrue(userId);
//    }
//
//    @Override
//    public boolean addUserToChatRoom(UUID chatRoomId, UUID userId) {
//        Optional<ChatRoom> chatRoomOpt = chatRoomRepository.findById(chatRoomId);
//        if (chatRoomOpt.isPresent()) {
//            ChatRoom chatRoom = chatRoomOpt.get();
//            if (chatRoom.isActive()) {
//                chatRoom.addParticipant(userId);
//                chatRoomRepository.save(chatRoom);
//                log.info("Added user {} to chat room: {}", userId, chatRoomId);
//                return true;
//            }
//        }
//        log.warn("Failed to add user {} to chat room: {} - room not found or inactive", userId, chatRoomId);
//        return false;
//    }
//
//    @Override
//    public boolean removeUserFromChatRoom(UUID chatRoomId, UUID userId) {
//        Optional<ChatRoom> chatRoomOpt = chatRoomRepository.findById(chatRoomId);
//        if (chatRoomOpt.isPresent()) {
//            ChatRoom chatRoom = chatRoomOpt.get();
//            chatRoom.removeParticipant(userId);
//            chatRoomRepository.save(chatRoom);
//            log.info("Removed user {} from chat room: {}", userId, chatRoomId);
//            return true;
//        }
//        log.warn("Failed to remove user {} from chat room: {} - room not found", userId, chatRoomId);
//        return false;
//    }
//
//    @Override
//    public void updateChatRoomActivity(UUID chatRoomId) {
//        chatRoomRepository.updateLastActivity(chatRoomId, Instant.now());
//        log.debug("Updated activity for chat room: {}", chatRoomId);
//    }
//
//    @Override
//    public boolean deactivateChatRoom(UUID chatRoomId) {
//        Optional<ChatRoom> chatRoomOpt = chatRoomRepository.findByChatRoomId(chatRoomId);
//        if (chatRoomOpt.isPresent()) {
//            chatRoomRepository.deactivateChatRoom(chatRoomId);
//            log.info("Deactivated chat room: {}", chatRoomId);
//            return true;
//        }
//        log.warn("Failed to deactivate chat room: {} - room not found", chatRoomId);
//        return false;
//    }
//
//    @Override
//    public User createOrUpdateUser(UUID userId, String username, String email, String displayName) {
//        Optional<User> existingUser = userRepository.findByUserId(userId);
//        User user;
//        if (existingUser.isPresent()) {
//            user = existingUser.get();
//            if (!username.equals(user.getUsername())) {
//                user.setUsername(username);
//            }
//            if (email != null && !email.equals(user.getEmail())) {
//                user.setEmail(email);
//            }
//            if (displayName != null && !displayName.equals(user.getDisplayName())) {
//                user.setDisplayName(displayName);
//            }
//        } else {
//            user = new User(userId, username, email, displayName);
//        }
//        user = userRepository.save(user);
//        log.debug("Created/updated user: {}", userId);
//        return user;
//    }
//
//    @Override
//    public Optional<User> getUser(UUID userId) {
//        return userRepository.findByUserId(userId);
//    }
//
//    @Override
//    public void setUserOnlineStatus(UUID userId, boolean online) {
//        LocalDateTime now = LocalDateTime.now();
//        userRepository.updateOnlineStatus(userId, online, now);
//        log.debug("Set user {} online status to: {}", userId, online);
//    }
//
//    @Override
//    public List<User> getChatRoomParticipants(UUID chatRoomId) {
//        Optional<ChatRoom> chatRoomOpt = chatRoomRepository.findByChatRoomId(chatRoomId);
//        if (chatRoomOpt.isPresent()) {
//            ChatRoom chatRoom = chatRoomOpt.get();
//            return chatRoom.getParticipants().stream()
//                    .map(userRepository::findByUserId)
//                    .filter(Optional::isPresent)
//                    .map(Optional::get)
//                    .collect(Collectors.toList());
//        }
//        return List.of();
//    }
//
//    @Override
//    public boolean isUserInChatRoom(UUID chatRoomId, UUID userId) {
//        return chatRoomRepository.isUserParticipant(chatRoomId, userId);
//    }
//
//    @Override
//    public long getActiveChatRoomCount() {
//        return chatRoomRepository.countByActiveTrue();
//    }
//
//    @Override
//    public long getTotalUserCount() {
//        return userRepository.count();
//    }
}
