package com.finconsgroup.itserr.marketplace.usercommunication.dm.service.impl;

import com.finconsgroup.itserr.marketplace.usercommunication.dm.entity.User;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.repository.UserRepository;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.security.WebSocketUser;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.service.SessionManagementService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;

import java.time.Instant;
import java.util.Optional;
import java.util.UUID;

/**
 * Shared implementation for {@link SessionManagementService}, containing common business logic.
 */
@RequiredArgsConstructor
@Slf4j
public abstract class AbstractSessionManagementService implements SessionManagementService {

    private final UserRepository userRepository;

    protected final User updateUserOnlineStatus(WebSocketUser webSocketUser, boolean online) {
        try {
            UUID userId = webSocketUser.getUserId();
            Optional<User> userOpt = userRepository.findById(userId);
            User user;

            if (userOpt.isPresent()) {
                user = userOpt.get();
                // refresh the name related fields, for fallback
                user.setFirstName(webSocketUser.getFirstName());
                user.setLastName(webSocketUser.getLastName());
                log.debug("Found existing user: {}", userId);
            } else {
                // Create new user if it doesn't exist
                user = new User(webSocketUser.getUserId());
                user.setFirstName(webSocketUser.getFirstName());
                user.setLastName(webSocketUser.getLastName());
                log.info("Created new user: {}", userId);
            }

            user.setOnline(online);
            user.setLastSeen(Instant.now());
            log.info("Updated user {} online status to: {}", userId, online);
            return userRepository.saveAndFlush(user);
        } catch (Exception e) {
            log.error("Failed to update online status for user {}: {}", webSocketUser.getUserId(), e.getMessage(), e);
            return null;
        }
    }

}
