package com.finconsgroup.itserr.marketplace.usercommunication.dm.mapper;

import com.finconsgroup.itserr.marketplace.usercommunication.dm.client.dto.userprofile.OutputUserProfileDmDto;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.dto.OutputUserDto;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.entity.User;
import org.mapstruct.AfterMapping;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.MappingTarget;

import java.time.Instant;

@Mapper(config = MapperConfiguration.class)
public interface UserMapper {

    /**
     * Converts a {@link User} into a {@link OutputUserDto}.
     *
     * @param entity the user entity
     * @return Created Output User Dto.
     */
    @Mapping(target = "imageUrl", ignore = true)
    OutputUserDto entityToOutputUserDto(User entity);

    /**
     * Converts a {@link OutputUserProfileDmDto} into a {@link User}.
     *
     * @param userProfileDmDto the user profile dm dto
     * @return Created User entity.
     */
    @Mapping(target = "online", ignore = true)
    @Mapping(target = "lastSeen", ignore = true)
    @Mapping(target = "createdAt", ignore = true)
    User userProfileDmDtoToEntity(OutputUserProfileDmDto userProfileDmDto);

    /**
     * Converts a {@link OutputUserProfileDmDto} into a {@link OutputUserDto}.
     *
     * @param userProfileDmDto the user profile dm dto
     * @return Created Output User Dto.
     */
    @Mapping(target = "online", ignore = true)
    @Mapping(target = "lastSeen", ignore = true)
    @Mapping(target = "createdAt", ignore = true)
    OutputUserDto userProfileDmDtoToOutputUserDto(OutputUserProfileDmDto userProfileDmDto);

    @AfterMapping
    default void afterMapUserDtoToEntity(@MappingTarget OutputUserDto outputUserDto, User user) {
        if (user.isOnline()) {
            // set the last seen to current time if the user is still online
            outputUserDto.setLastSeen(Instant.now());
        }
    }

}
