package com.finconsgroup.itserr.marketplace.usercommunication.dm.configuration.properties;

import lombok.AllArgsConstructor;
import lombok.Getter;
import org.springframework.boot.context.properties.ConfigurationProperties;

import java.time.Duration;
import java.util.Map;

/**
 * Represents the configuration properties for a web sockets.
 */
@ConfigurationProperties(prefix = "user-communication.dm.web-socket")
@Getter
@AllArgsConstructor
public class WebSocketConfigurationProperties {

    /**
     * Specifies the allowed origins for cross-origin WebSocket requests. Defaults to *.
     */
    private String corsAllowedOrigins;


    /**
     * Flag to indicate if the external broker i.e. broker relay should be enabled
     */
    private boolean enableBrokerRelay;

    /**
     * External Broker relay host
     */
    private String relayHost;

    /**
     * External Broker relay virtual host
     */
    private String relayVirtualHost;

    /**
     * External Broker relay port
     */
    private int relayPort;

    /**
     * External Broker client login
     */
    private String relayClientLogin;

    /**
     * External Broker client password
     */
    private String relayClientPassword;

    /**
     * External Broker system login
     */
    private String relaySystemLogin;

    /**
     * External Broker system password
     */
    private String relaySystemPassword;

    /**
     * The prefix to be used for all STOMP destinations for external broker.
     */
    private String relayDestinationPrefix;

    /**
     * The OAuth Keycloak Token URL in case if RabbitMQ is configured with OAuth backend.
     */
    private String relayOauthKeycloakTokenUrl;

    /**
     * The OAuth Grant Type in case if RabbitMQ is configured with OAuth backend.
     */
    private String relayOauthGrantType;

    /**
     * The OAuth Token Refresh Delay in case if RabbitMQ is configured with OAuth backend.
     */
    private Duration relayOauthRefreshDelay;

    /**
     * The OAuth Token Refresh Period in case if RabbitMQ is configured with OAuth backend.
     */
    private Duration relayOauthRefreshPeriod;

    /**
     * The OAuth additional parameters in case if RabbitMQ is configured with OAuth backend.
     */
    private Map<String, String> relayOauthParameters;
}
