package com.finconsgroup.itserr.marketplace.usercommunication.dm.api;

import com.finconsgroup.itserr.marketplace.core.web.utils.OpenApiUtils;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.entity.User;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;
import java.util.UUID;

/**
 * REST API contract for user endpoints related to listing, searching, and maintaining users.
 * Implemented by UserController. These mappings are used to generate OpenAPI and JavaDoc docs.
 */
@Tag(name = "User", description = "Operations related to user management")
@SecurityRequirement(name = "BearerAuth")
@ApiResponses(value = {
        @ApiResponse(responseCode = "500", ref = OpenApiUtils.RESPONSE_INTERNAL_SERVER_ERROR)
})
public interface UserApi {
    // TODO: Check Later as this feature is not a priority for now
//    /**
//     * Retrieve all users ordered by username.
//     * @return HTTP 200 with the ordered list of users; 500 on server errors
//     */
//    @Operation(summary = "List all users", description = "Get all users ordered by username.")
//    @ApiResponses(value = {
//            @ApiResponse(responseCode = "200", description = "Users retrieved")
//    })
//    @GetMapping("/user-communication/users")
//    ResponseEntity<List<User>> getAllUsers();
//
    /**
     * Retrieve all users currently marked online.
     * @return HTTP 200 with the list of online users; 500 on server errors
     */
    @Operation(summary = "List online users", description = "Get all users that are currently online.")
    @ApiResponses(value = {
            @ApiResponse(responseCode = "200", description = "Online users retrieved")
    })
    @GetMapping(value = "/user-communication/users/online", produces = MediaType.APPLICATION_JSON_VALUE)
    ResponseEntity<List<User>> getOnlineUsers();

    /**
     * Retrieve users that are online or have been active within the last hour.
     * @return HTTP 200 with the list of recently active users; 500 on server errors
     */
    @Operation(summary = "Recently active users", description = "Get users online or active within last hour.")
    @ApiResponses(value = {
            @ApiResponse(responseCode = "200", description = "Recently active users retrieved")
    })
    @GetMapping(value = "/user-communication/users/recent", produces = MediaType.APPLICATION_JSON_VALUE)
    ResponseEntity<List<User>> getRecentlyActiveUsers();

    /**
     * Retrieve a user by their business userId.
     * @param userId the business user identifier
     * @return HTTP 200 with user if found; 404 if not; 500 on server errors
     */
    @Operation(summary = "Get user by ID", description = "Retrieve a user by userId.")
    @ApiResponses(value = {
            @ApiResponse(responseCode = "200", description = "User found"),
            @ApiResponse(responseCode = "404", description = "User not found")
    })
    @GetMapping(value = "/user-communication/users/{userId}", produces = MediaType.APPLICATION_JSON_VALUE)
    ResponseEntity<User> getUserById(@PathVariable UUID userId);

//    /**
//     * Search for users by username or display name containing the query.
//     * @param query free-text query for username/display name
//     * @return HTTP 200 with matching users; 500 on server errors
//     */
//    @Operation(summary = "Search users", description = "Search users by username or display name.")
//    @ApiResponses(value = {
//            @ApiResponse(responseCode = "200", description = "Search results returned")
//    })
//    @GetMapping("/user-communication/users/search")
//    ResponseEntity<List<User>> searchUsers(@RequestParam String query);
//
//    /**
//     * Create a new user or update an existing one by userId.
//     * @param user user payload
//     * @return HTTP 200 with created/updated user; 400 for invalid input; 500 on server errors
//     */
//    @Operation(summary = "Create or update user", description = "Create a new user or update if already exists.")
//    @ApiResponses(value = {
//            @ApiResponse(responseCode = "200", description = "User created/updated"),
//            @ApiResponse(responseCode = "400", description = "Invalid request")
//    })
//    @PostMapping("/user-communication/users")
//    ResponseEntity<User> createOrUpdateUser(@RequestBody User user);

    /**
     * Update the online status flag for a user.
     * @param online new online flag value
     * @return HTTP 200 on success; 500 on server errors
     */
    @Operation(summary = "Update online status", description = "Update user's online flag.")
    @ApiResponses(value = {
            @ApiResponse(responseCode = "200", description = "Status updated")
    })
    @PutMapping(value = "/user-communication/users/status", produces = MediaType.TEXT_PLAIN_VALUE)
    ResponseEntity<String> updateUserStatus(@RequestParam boolean online);
}
