/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.usercommunication.dm.service.impl;

import com.finconsgroup.itserr.marketplace.core.web.exception.WP2AuthorizationException;
import com.finconsgroup.itserr.marketplace.core.web.exception.WP2ResourceNotFoundException;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.constant.SecurityConstants;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.entity.Conversation;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.enums.MessageType;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.repository.ConversationParticipantRepository;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.repository.ConversationRepository;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.service.PreConditionService;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.service.impl.DefaultPreConditionService;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DefaultPreConditionService
implements PreConditionService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultPreConditionService.class);
    private final ConversationRepository conversationRepository;
    private final ConversationParticipantRepository conversationParticipantRepository;

    @Transactional(propagation=Propagation.REQUIRED, readOnly=true, noRollbackFor={Exception.class})
    public Conversation checkConversation(UUID conversationId) {
        return this.conversationRepository.findById(conversationId).filter(Conversation::isActive).orElseThrow(() -> new WP2ResourceNotFoundException(conversationId));
    }

    @Transactional(propagation=Propagation.REQUIRED, readOnly=true, noRollbackFor={Exception.class})
    public Conversation checkUserAndConversation(UUID userId, UUID conversationId) {
        Conversation conversation = this.checkConversation(conversationId);
        this.checkUserAndConversation(userId, conversation);
        return conversation;
    }

    @Transactional(propagation=Propagation.REQUIRED, readOnly=true, noRollbackFor={Exception.class})
    public Conversation checkUserAndConversationAndMessage(UUID userId, UUID conversationId, MessageType messageType) {
        Conversation conversation = this.checkConversation(conversationId);
        switch (1.$SwitchMap$com$finconsgroup$itserr$marketplace$usercommunication$dm$enums$MessageType[messageType.ordinal()]) {
            case 1: {
                if (SecurityConstants.SYSTEM_USER_ID.equals(userId)) break;
                log.warn("User {} attempted to send message with type {} to conversation {} but is not allowed", new Object[]{userId, messageType, conversationId});
                throw new WP2AuthorizationException("Not Authorized");
            }
            default: {
                this.checkUserAndConversation(userId, conversation);
            }
        }
        return conversation;
    }

    public void checkUserAndConversation(UUID userId, Conversation conversation) {
        UUID conversationId = conversation.getId();
        if (!this.conversationParticipantRepository.existsByConversationIdAndUserIdAndActiveIsTrue(conversationId, userId)) {
            log.warn("User {} attempted to access conversation {} but is not allowed", (Object)userId, (Object)conversationId);
            throw new WP2AuthorizationException("Not Authorized");
        }
    }

    @Generated
    public DefaultPreConditionService(ConversationRepository conversationRepository, ConversationParticipantRepository conversationParticipantRepository) {
        this.conversationRepository = conversationRepository;
        this.conversationParticipantRepository = conversationParticipantRepository;
    }
}

