/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.usercommunication.dm.api;

import com.finconsgroup.itserr.marketplace.usercommunication.dm.entity.User;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import java.util.UUID;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Tag(name="User", description="Operations related to user management")
@SecurityRequirement(name="BearerAuth")
@ApiResponses(value={@ApiResponse(responseCode="500", ref="InternalServerError")})
public interface UserApi {
    @Operation(summary="List online users", description="Get all users that are currently online.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Online users retrieved")})
    @GetMapping(value={"/user-communication/users/online"}, produces={"application/json"})
    public ResponseEntity<List<User>> getOnlineUsers();

    @Operation(summary="Recently active users", description="Get users online or active within last hour.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Recently active users retrieved")})
    @GetMapping(value={"/user-communication/users/recent"}, produces={"application/json"})
    public ResponseEntity<List<User>> getRecentlyActiveUsers();

    @Operation(summary="Get user by ID", description="Retrieve a user by userId.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="User found"), @ApiResponse(responseCode="404", description="User not found")})
    @GetMapping(value={"/user-communication/users/{userId}"}, produces={"application/json"})
    public ResponseEntity<User> getUserById(@PathVariable UUID var1);

    @Operation(summary="Update online status", description="Update user's online flag.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Status updated")})
    @PutMapping(value={"/user-communication/users/status"}, produces={"text/plain"})
    public ResponseEntity<String> updateUserStatus(@RequestParam boolean var1);
}

