/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.usercommunication.dm.api;

import com.finconsgroup.itserr.marketplace.usercommunication.dm.dto.InputBulkMessagesDto;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.dto.InputMuteConversationDto;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.dto.OutputChatMessageDto;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.dto.OutputConversationDto;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.dto.OutputConversationParticipantDto;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.dto.OutputConversationStatsDto;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.dto.OutputSearchResultDto;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.dto.OutputUnreadMessageSummaryDto;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Positive;
import jakarta.validation.constraints.PositiveOrZero;
import java.util.List;
import java.util.UUID;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Sort;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;

@Tag(name="Conversation", description="Operations related to all conversations i.e. direct or group")
@SecurityRequirement(name="BearerAuth")
@ApiResponses(value={@ApiResponse(responseCode="500", ref="InternalServerError")})
public interface ConversationApi {
    @Operation(summary="Get conversation", description="Get conversation details by ID.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Conversation found"), @ApiResponse(responseCode="404", description="Conversation not found")})
    @GetMapping(value={"/user-communication/conversations/{conversationId}"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    public OutputConversationDto getConversationById(@PathVariable UUID var1);

    @Operation(summary="Recent conversations for user", description="Get user's recently active conversations.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Conversations retrieved")})
    @ResponseStatus(value=HttpStatus.OK)
    @GetMapping(value={"/user-communication/conversations/recent/user"}, produces={"application/json"})
    public Page<OutputConversationDto> getRecentConversationsForUser(@RequestParam(name="pageNumber", defaultValue="0", required=false) @PositiveOrZero int var1, @RequestParam(name="pageSize", defaultValue="10", required=false) @Positive int var2, @RequestParam(name="sort", defaultValue="lastActivity", required=false) String var3, @RequestParam(name="direction", defaultValue="DESC", required=false) Sort.Direction var4);

    @Operation(summary="Get participants", description="List participants of a conversation.", hidden=true)
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Participants retrieved"), @ApiResponse(responseCode="404", description="Conversation not found")})
    @GetMapping(value={"/user-communication/conversations/{conversationId}/participants"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    public List<OutputConversationParticipantDto> getConversationParticipants(@PathVariable UUID var1);

    @Operation(summary="Leave conversation", description="Leave a conversation.", hidden=true)
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Left conversation"), @ApiResponse(responseCode="404", description="Conversation not found"), @ApiResponse(responseCode="400", description="Invalid request")})
    @PostMapping(value={"/user-communication/conversations/{conversationId}/leave"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void leaveConversation(@PathVariable UUID var1);

    @Operation(summary="Mute conversation", description="Mute notifications for a conversation.", hidden=true)
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Conversation muted"), @ApiResponse(responseCode="404", description="Conversation not found"), @ApiResponse(responseCode="400", description="Invalid request")})
    @PostMapping(value={"/user-communication/conversations/{conversationId}/mute"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void muteConversation(@PathVariable UUID var1, @RequestBody InputMuteConversationDto var2);

    @Operation(summary="Mark conversation as read", description="Mark all messages as read for a user in a conversation.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Conversation marked as read"), @ApiResponse(responseCode="404", description="Conversation not found"), @ApiResponse(responseCode="400", description="Invalid request")})
    @PostMapping(value={"/user-communication/conversations/{conversationId}/read"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void markConversationAsRead(@PathVariable(value="conversationId") UUID var1);

    @Operation(summary="Mark conversation as read upto given message", description="Mark all messages as read for a user in a conversation upto the provided message.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Conversation marked as read"), @ApiResponse(responseCode="404", description="Conversation not found"), @ApiResponse(responseCode="400", description="Invalid request")})
    @PostMapping(value={"/user-communication/conversations/{conversationId}/read-upto/{messageId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void markConversationUptoMessageAsRead(@PathVariable(value="conversationId") UUID var1, @PathVariable(value="messageId") UUID var2);

    @Operation(summary="Mark one or more messages for the conversation as read", description="Mark one or more messages as read for a user in a conversation.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Conversation marked as read"), @ApiResponse(responseCode="404", description="Conversation not found"), @ApiResponse(responseCode="400", description="Invalid request")})
    @PostMapping(value={"/user-communication/conversations/{conversationId}/read-bulk"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void markBulkMessagesAsRead(@PathVariable(value="conversationId") UUID var1, @RequestBody @Valid InputBulkMessagesDto var2);

    @Operation(summary="Search conversations", description="Search conversations by name or other criteria.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Search results returned"), @ApiResponse(responseCode="500", description="Internal server error")})
    @GetMapping(value={"/user-communication/conversations/search"}, produces={"application/json"})
    public OutputSearchResultDto searchConversations(@RequestParam(name="query") String var1, @RequestParam(name="pageNumber", defaultValue="0", required=false) @PositiveOrZero int var2, @RequestParam(name="pageSize", defaultValue="10", required=false) @Positive int var3, @RequestParam(name="sort", defaultValue="createdAt", required=false) String var4, @RequestParam(name="direction", defaultValue="DESC", required=false) Sort.Direction var5);

    @Operation(summary="Conversation statistics", description="Get system-wide conversation stats.", hidden=true)
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Statistics returned")})
    @GetMapping(value={"/user-communication/conversations/stats"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    public OutputConversationStatsDto getConversationStats();

    @Operation(summary="Get conversation messages", description="List messages for a conversation with pagination.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Messages retrieved"), @ApiResponse(responseCode="404", description="Conversation not found")})
    @GetMapping(value={"/user-communication/conversations/{conversationId}/messages"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    public Page<OutputChatMessageDto> getConversationMessages(@PathVariable UUID var1, @RequestParam(name="pageNumber", defaultValue="0", required=false) @PositiveOrZero int var2, @RequestParam(name="pageSize", defaultValue="10", required=false) @Positive int var3, @RequestParam(name="sort", defaultValue="createdAt", required=false) String var4, @RequestParam(name="direction", defaultValue="ASC", required=false) Sort.Direction var5);

    @Operation(summary="Get unread summary", description="Get summary about unread messages for a user.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Unread summary returned")})
    @GetMapping(value={"/user-communication/conversations/unread/user"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    public OutputUnreadMessageSummaryDto getUnreadMessageSummary();
}

