package com.finconsgroup.itserr.marketplace.usercommunication.dm.service;

import com.finconsgroup.itserr.marketplace.core.web.exception.WP2AuthorizationException;
import com.finconsgroup.itserr.marketplace.core.web.exception.WP2ResourceNotFoundException;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.entity.Conversation;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.enums.MessageType;

import java.util.UUID;

/**
 * Service contract for managing pre-conditions for accessing conversations (direct and group).
 * Each method is documented to improve generated JavaDoc and maintainability.
 */
public interface PreConditionService {

    /**
     * Checks if the conversation exists and is active.
     * Returns the found conversation.
     *
     * @param conversationId the conversation id
     * @throws WP2ResourceNotFoundException if conversation id does not exist
     */
    @SuppressWarnings("UnusedReturnValue")
    Conversation checkConversation(UUID conversationId);

    /**
     * Checks if the user is allowed to access the conversation.
     * Returns the found conversation.
     *
     * @param userId         the user id
     * @param conversationId the conversation id
     * @throws WP2ResourceNotFoundException if conversation id does not exist
     * @throws WP2AuthorizationException    if not allowed
     */
    Conversation checkUserAndConversation(UUID userId, UUID conversationId);

    /**
     * Checks if the user is allowed to send the message of messageType to the conversation.
     * Returns the found conversation.
     *
     * @param userId         the user id
     * @param conversationId the conversation id
     * @param messageType    the message type
     * @throws WP2ResourceNotFoundException if conversation id does not exist
     * @throws WP2AuthorizationException    if not allowed
     */
    Conversation checkUserAndConversationAndMessage(UUID userId, UUID conversationId, MessageType messageType);
}
