package com.finconsgroup.itserr.marketplace.usercommunication.dm.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.enums.ConversationType;
import io.swagger.v3.oas.annotations.Hidden;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;

import java.time.Instant;
import java.util.UUID;

@SuperBuilder
@Data
@NoArgsConstructor
public class OutputConversationDto {

    private UUID id;

    private ConversationType conversationType;

    private String name; // Other user's name for DIRECT, group name for GROUP

    private String description; // null for DIRECT, description for GROUP

    @Hidden
    @JsonIgnore // ignore the field for json response, as it will be mapped to createdByUser
    private UUID createdBy;

    @JsonProperty("createdBy")
    private OutputUserDto createdByUser;

    private Instant createdAt;

    private Instant lastActivity;

    private boolean active;

    private boolean privateFlag; // true for DIRECT and GROUP

    private Integer maxParticipants; // null for DIRECT (always 2), configurable for others

    private OutputConversationMessageSummaryDto messageSummary;

    private OutputUserDto receiver; // only populated for direct chats
}
