/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.usercommunication.dm.service.impl;

import com.finconsgroup.itserr.marketplace.usercommunication.dm.bean.ChatMessageApplicationEvent;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.entity.ChatMessage;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.service.MessagingService;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnProperty(value={"type"}, prefix="user-communication.dm.messaging", havingValue="SPRING_EVENTS")
public class SpringEventMessagingService
implements MessagingService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SpringEventMessagingService.class);
    private final ApplicationEventPublisher applicationEventPublisher;

    public void sendChatMessage(@NonNull ChatMessage chatMessage) {
        log.info("Sending chat message: {} from user: {} using Spring Application Event Publisher", (Object)chatMessage.getId(), (Object)chatMessage.getSenderId());
        this.applicationEventPublisher.publishEvent((ApplicationEvent)new ChatMessageApplicationEvent(chatMessage, false));
    }

    public void sendUserNotification(@NonNull ChatMessage notification) {
        this.applicationEventPublisher.publishEvent((ApplicationEvent)new ChatMessageApplicationEvent(notification, true));
    }

    @Generated
    public SpringEventMessagingService(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }
}

