/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.usercommunication.dm.service.impl;

import com.finconsgroup.itserr.marketplace.core.entity.AbstractUUIDEntity;
import com.finconsgroup.itserr.marketplace.core.web.dto.OutputPageDto;
import com.finconsgroup.itserr.marketplace.core.web.exception.WP2ResourceNotFoundException;
import com.finconsgroup.itserr.marketplace.core.web.exception.WP2ValidationException;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.component.ConversationHelper;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.dto.InputBulkMessagesDto;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.dto.OutputChatMessageDto;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.dto.OutputConversationDto;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.dto.OutputConversationMessageSummaryDto;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.dto.OutputConversationParticipantDto;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.dto.OutputConversationStatsDto;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.dto.OutputSearchResultDto;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.entity.ChatMessage;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.entity.Conversation;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.entity.ConversationParticipant;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.enums.ConversationType;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.mapper.ConversationMapper;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.mapper.ConversationParticipantMapper;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.repository.ChatMessageRepository;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.repository.ConversationParticipantRepository;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.repository.ConversationRepository;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.repository.MessageReadReceiptRepository;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.repository.OfflineMessageRepository;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.service.ChatMessageService;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.service.ConversationService;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.service.PreConditionService;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.util.SortUtils;
import java.time.Instant;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ConversationServiceImpl
implements ConversationService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConversationServiceImpl.class);
    private final ConversationRepository conversationRepository;
    private final ConversationParticipantRepository participantRepository;
    private final ChatMessageService chatMessageService;
    private final ChatMessageRepository chatMessageRepository;
    private final MessageReadReceiptRepository readReceiptRepository;
    private final OfflineMessageRepository offlineMessageRepository;
    private final ConversationMapper conversationMapper;
    private final PreConditionService preConditionService;
    private final ConversationHelper conversationHelper;
    private final ConversationParticipantMapper conversationParticipantMapper;

    @Transactional(propagation=Propagation.REQUIRED, readOnly=true, noRollbackFor={Exception.class})
    public OutputConversationDto getConversation(UUID userId, UUID conversationId) {
        Conversation conversation = this.preConditionService.checkUserAndConversation(userId, conversationId);
        OutputConversationDto conversationDto = conversation.isDirect() ? this.mapToDirectOutputConversationDto(userId, conversation) : this.conversationMapper.entityToOutputConversationDto(conversation);
        Map messageSummaryByConversationId = this.chatMessageService.getConversationMessageSummary(userId, List.of(conversation));
        conversationDto.setMessageSummary((OutputConversationMessageSummaryDto)messageSummaryByConversationId.get(conversationId));
        return conversationDto;
    }

    @Transactional(propagation=Propagation.REQUIRED, readOnly=true, noRollbackFor={Exception.class})
    public Page<OutputConversationDto> getRecentConversationsForUser(UUID userId, Pageable pageable) {
        Page recentConversationsPage = this.conversationRepository.findConversationsForUser(userId, pageable);
        Page conversationDtoPage = this.mapToOutputConverstationDtoPage(userId, recentConversationsPage);
        Map messageSummaryByConversationId = this.chatMessageService.getConversationMessageSummary(userId, recentConversationsPage.getContent());
        conversationDtoPage.getContent().forEach(conversationDto -> conversationDto.setMessageSummary((OutputConversationMessageSummaryDto)messageSummaryByConversationId.get(conversationDto.getId())));
        return conversationDtoPage;
    }

    @Transactional(propagation=Propagation.REQUIRED, readOnly=true, noRollbackFor={Exception.class})
    public Page<OutputChatMessageDto> getConversationMessages(UUID userId, UUID conversationId, Pageable pageable) {
        Conversation conversation = this.preConditionService.checkUserAndConversation(userId, conversationId);
        return this.chatMessageService.getConversationMessages(conversation, pageable);
    }

    @Transactional(propagation=Propagation.REQUIRED, readOnly=true, noRollbackFor={Exception.class})
    public List<OutputConversationParticipantDto> getConversationParticipants(UUID conversationId) {
        List participants = this.participantRepository.findByConversationIdAndActiveIsTrue(conversationId);
        return participants.stream().map(arg_0 -> ((ConversationParticipantMapper)this.conversationParticipantMapper).entityToOutputConversationParticipantDto(arg_0)).toList();
    }

    @Transactional(propagation=Propagation.REQUIRED, readOnly=true, noRollbackFor={Exception.class})
    public boolean isUserParticipant(UUID conversationId, UUID userId) {
        return this.participantRepository.existsByConversationIdAndUserIdAndActiveIsTrue(conversationId, userId);
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void muteConversation(UUID conversationId, UUID userId, boolean muted) {
        if (!this.participantRepository.existsByConversationIdAndUserIdAndActiveIsTrue(conversationId, userId)) {
            throw new WP2ValidationException("User it not an active participant");
        }
        this.participantRepository.updateParticipantMuteStatus(conversationId, userId, muted);
        log.info("User {} {} conversation {}", new Object[]{userId, muted ? "muted" : "unmuted", conversationId});
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void markConversationAsRead(@NonNull UUID userId, @NonNull UUID conversationId) {
        Objects.requireNonNull(userId, "userId must not be null");
        Objects.requireNonNull(conversationId, "conversationId must not be null");
        Conversation conversation = this.preConditionService.checkUserAndConversation(userId, conversationId);
        Instant readAt = Instant.now();
        this.participantRepository.updateLastReadAt(conversationId, userId, readAt);
        int markedCount = this.chatMessageService.markConversationAsRead(conversation, userId, readAt);
        log.info("Marked {} messages as read for user {} in conversation {} (type: {})", new Object[]{markedCount, userId, conversationId, conversation.getConversationType()});
        try {
            int deletedDeliveredMessages = this.offlineMessageRepository.deleteByRecipientUserIdAndConversationIdAndDeliveredTrue(userId, conversationId);
            int deletedUndeliveredMessages = this.offlineMessageRepository.deleteByRecipientUserIdAndConversationIdAndDeliveredFalse(userId, conversationId);
            int totalDeleted = deletedDeliveredMessages + deletedUndeliveredMessages;
            if (totalDeleted > 0) {
                log.info("Cleaned up {} offline messages (delivered: {}, undelivered: {}) for user {} in conversation {}", new Object[]{totalDeleted, deletedDeliveredMessages, deletedUndeliveredMessages, userId, conversationId});
            }
        }
        catch (Exception e) {
            log.warn("Failed to clean up offline messages for user {} in conversation {}: {}", new Object[]{userId, conversationId, e.getMessage()});
        }
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void markConversationUptoMessageAsRead(@NonNull UUID userId, @NonNull UUID conversationId, @NonNull UUID messageId) {
        Objects.requireNonNull(userId, "userId must not be null");
        Objects.requireNonNull(conversationId, "conversationId must not be null");
        Objects.requireNonNull(messageId, "messageId must not be null");
        Conversation conversation = this.preConditionService.checkUserAndConversation(userId, conversationId);
        Instant readAt = Instant.now();
        ChatMessage chatMessage = (ChatMessage)this.chatMessageRepository.findById(messageId).orElseThrow(() -> new WP2ResourceNotFoundException(messageId));
        if (!conversationId.equals(chatMessage.getConversationId())) {
            throw new WP2ValidationException("Message does not belong to conversation");
        }
        Instant messageCreatedAt = chatMessage.getCreatedAt();
        this.participantRepository.updateLastReadAt(conversationId, userId, readAt);
        int markedCount = this.chatMessageService.markConversationMessagesUptoCreatedAtAsRead(conversation, userId, readAt, messageCreatedAt);
        log.info("Marked {} messages as read for user {} in conversation {} (type: {})", new Object[]{markedCount, userId, conversationId, conversation.getConversationType()});
        try {
            int deletedDeliveredMessages = this.offlineMessageRepository.deleteByRecipientUserIdAndConversationIdAndDeliveredTrue(userId, conversationId);
            int deletedUndeliveredMessages = this.offlineMessageRepository.deleteByRecipientUserIdAndConversationIdAndDeliveredFalseUptoCreatedAt(userId, conversationId, messageCreatedAt);
            int totalDeleted = deletedDeliveredMessages + deletedUndeliveredMessages;
            if (totalDeleted > 0) {
                log.info("Cleaned up {} offline messages (delivered: {}, undelivered: {}) for user {} in conversation {}", new Object[]{totalDeleted, deletedDeliveredMessages, deletedUndeliveredMessages, userId, conversationId});
            }
        }
        catch (Exception e) {
            log.warn("Failed to clean up offline messages for user {} in conversation {}: {}", new Object[]{userId, conversationId, e.getMessage()});
        }
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void markBulkMessagesAsRead(@NonNull UUID userId, @NonNull UUID conversationId, @NonNull InputBulkMessagesDto request) {
        Objects.requireNonNull(userId, "userId must not be null");
        Objects.requireNonNull(conversationId, "conversationId must not be null");
        Objects.requireNonNull(request, "request must not be null");
        if (request.getIds() == null || request.getIds().isEmpty()) {
            throw new WP2ValidationException("Ids must not be null or empty");
        }
        Conversation conversation = this.preConditionService.checkUserAndConversation(userId, conversationId);
        Instant readAt = Instant.now();
        List chatMessages = this.chatMessageRepository.findByIdInAndConversationId((Collection)request.getIds(), conversationId);
        Set chatMessageIds = chatMessages.stream().map(AbstractUUIDEntity::getId).collect(Collectors.toSet());
        if (chatMessages.size() != request.getIds().size()) {
            if (log.isDebugEnabled()) {
                HashSet missingMessageIds = new HashSet(request.getIds());
                missingMessageIds.removeAll(chatMessageIds);
                log.debug("The following message ids do not belong to the conversation - {}: {}", (Object)conversationId, missingMessageIds);
            }
            throw new WP2ValidationException("One or more messages do not belong to conversation");
        }
        this.participantRepository.updateLastReadAt(conversationId, userId, readAt);
        int markedCount = this.chatMessageService.markConversationBulkMessagesAsRead(conversation, userId, readAt, chatMessageIds);
        log.info("Marked {} messages as read for user {} in conversation {} (type: {})", new Object[]{markedCount, userId, conversationId, conversation.getConversationType()});
        try {
            int deletedDeliveredMessages = this.offlineMessageRepository.deleteByRecipientUserIdAndConversationIdAndDeliveredTrue(userId, conversationId);
            int deletedUndeliveredMessages = this.offlineMessageRepository.deleteByRecipientUserIdAndConversationIdAndDeliveredFalseAndMessageIdIn(userId, conversationId, chatMessageIds);
            int totalDeleted = deletedDeliveredMessages + deletedUndeliveredMessages;
            if (totalDeleted > 0) {
                log.info("Cleaned up {} offline messages (delivered: {}, undelivered: {}) for user {} in conversation {}", new Object[]{totalDeleted, deletedDeliveredMessages, deletedUndeliveredMessages, userId, conversationId});
            }
        }
        catch (Exception e) {
            log.warn("Failed to clean up offline messages for user {} in conversation {}: {}", new Object[]{userId, conversationId, e.getMessage()});
        }
    }

    @Transactional(propagation=Propagation.REQUIRED, readOnly=true, noRollbackFor={Exception.class})
    public List<ConversationParticipant> getConversationsWithUnreadMessages(UUID userId) {
        return this.participantRepository.findConversationsWithUnreadMessages(userId);
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void leaveConversation(UUID conversationId, UUID userId) {
        Optional participantOpt = this.participantRepository.findByConversationIdAndUserId(conversationId, userId);
        if (participantOpt.isEmpty() || !((ConversationParticipant)participantOpt.get()).isActive()) {
            throw new WP2ValidationException("User is not an active participant");
        }
        Optional conversationOpt = this.conversationRepository.findById(conversationId);
        if (conversationOpt.isPresent() && ((Conversation)conversationOpt.get()).isDirect()) {
            this.conversationRepository.deactivateConversation(conversationId);
            log.info("Direct conversation {} deactivated when user {} left", (Object)conversationId, (Object)userId);
        } else {
            this.participantRepository.removeParticipant(conversationId, userId);
            log.info("User {} left conversation {}", (Object)userId, (Object)conversationId);
        }
    }

    @Transactional(propagation=Propagation.REQUIRED, readOnly=true, noRollbackFor={Exception.class})
    public OutputSearchResultDto searchConversations(UUID userId, String searchTerm, Pageable pageable) {
        PageRequest pageRequest = PageRequest.of((int)pageable.getPageNumber(), (int)pageable.getPageSize(), (Sort)SortUtils.mapSortProperty((Map)ConversationRepository.FIELD_COLUMN_NAME_MAP, (Sort)pageable.getSort()));
        Page searchResultPage = this.conversationRepository.findByNameContainingIgnoreCase(userId, searchTerm, (Pageable)pageRequest);
        Page conversationDtoPage = this.mapToOutputConverstationDtoPage(userId, searchResultPage);
        Page chatMessageDtoPage = this.chatMessageService.searchMessages(userId, searchTerm, pageable);
        return OutputSearchResultDto.builder().conversations(OutputPageDto.fromPage((Page)conversationDtoPage)).messages(OutputPageDto.fromPage((Page)chatMessageDtoPage)).build();
    }

    @Transactional(propagation=Propagation.REQUIRED, readOnly=true, noRollbackFor={Exception.class})
    public OutputConversationStatsDto getConversationStats() {
        long directCount = this.conversationRepository.countByConversationTypeAndActiveTrue(ConversationType.DIRECT);
        long groupCount = this.conversationRepository.countByConversationTypeAndActiveTrue(ConversationType.GROUP);
        return new OutputConversationStatsDto(directCount, groupCount);
    }

    private OutputConversationDto mapToDirectOutputConversationDto(UUID userId, Conversation conversation) {
        return this.conversationHelper.populateDetailsForDirect(userId, conversation);
    }

    private Page<OutputConversationDto> mapToOutputConverstationDtoPage(UUID userId, Page<Conversation> conversationPage) {
        List conversationDtos = this.conversationHelper.populateDetailsForDirect(userId, conversationPage.getContent());
        return new PageImpl(conversationDtos, conversationPage.getPageable(), conversationPage.getTotalElements());
    }

    @Generated
    public ConversationServiceImpl(ConversationRepository conversationRepository, ConversationParticipantRepository participantRepository, ChatMessageService chatMessageService, ChatMessageRepository chatMessageRepository, MessageReadReceiptRepository readReceiptRepository, OfflineMessageRepository offlineMessageRepository, ConversationMapper conversationMapper, PreConditionService preConditionService, ConversationHelper conversationHelper, ConversationParticipantMapper conversationParticipantMapper) {
        this.conversationRepository = conversationRepository;
        this.participantRepository = participantRepository;
        this.chatMessageService = chatMessageService;
        this.chatMessageRepository = chatMessageRepository;
        this.readReceiptRepository = readReceiptRepository;
        this.offlineMessageRepository = offlineMessageRepository;
        this.conversationMapper = conversationMapper;
        this.preConditionService = preConditionService;
        this.conversationHelper = conversationHelper;
        this.conversationParticipantMapper = conversationParticipantMapper;
    }
}

