/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.usercommunication.dm.service.impl;

import com.finconsgroup.itserr.marketplace.usercommunication.dm.entity.User;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.repository.UserRepository;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.security.WebSocketUser;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.service.SessionManagementService;
import java.time.Instant;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSessionManagementService
implements SessionManagementService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractSessionManagementService.class);
    private final UserRepository userRepository;

    protected final User updateUserOnlineStatus(WebSocketUser webSocketUser, boolean online) {
        try {
            User user;
            UUID userId = webSocketUser.getUserId();
            Optional userOpt = this.userRepository.findById(userId);
            if (userOpt.isPresent()) {
                user = (User)userOpt.get();
                user.setFirstName(webSocketUser.getFirstName());
                user.setLastName(webSocketUser.getLastName());
                log.debug("Found existing user: {}", (Object)userId);
            } else {
                user = new User(webSocketUser.getUserId());
                user.setFirstName(webSocketUser.getFirstName());
                user.setLastName(webSocketUser.getLastName());
                log.info("Created new user: {}", (Object)userId);
            }
            user.setOnline(online);
            user.setLastSeen(Instant.now());
            log.info("Updated user {} online status to: {}", (Object)userId, (Object)online);
            return (User)this.userRepository.saveAndFlush((Object)user);
        }
        catch (Exception e) {
            log.error("Failed to update online status for user {}: {}", new Object[]{webSocketUser.getUserId(), e.getMessage(), e});
            return null;
        }
    }

    @Generated
    public AbstractSessionManagementService(UserRepository userRepository) {
        this.userRepository = userRepository;
    }
}

