/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.usercommunication.dm.security.config;

import com.finconsgroup.itserr.marketplace.core.web.security.jwt.JwtTokenVerifier;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.configuration.properties.UserCommunicationSecurityProperties;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.security.AuthenticationChannelInterceptor;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.security.SubscriptionAuthorizationChannelInterceptor;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.springframework.context.annotation.Configuration;
import org.springframework.messaging.handler.invocation.HandlerMethodArgumentResolver;
import org.springframework.messaging.simp.config.ChannelRegistration;
import org.springframework.messaging.support.ChannelInterceptor;
import org.springframework.security.messaging.access.intercept.AuthorizationChannelInterceptor;
import org.springframework.security.messaging.context.AuthenticationPrincipalArgumentResolver;
import org.springframework.security.messaging.context.SecurityContextChannelInterceptor;
import org.springframework.web.socket.config.annotation.WebSocketMessageBrokerConfigurer;

@Configuration
public class WebSocketSecurityConfig
implements WebSocketMessageBrokerConfigurer {
    private final Optional<JwtTokenVerifier> jwtTokenVerifier;
    private final AuthorizationChannelInterceptor authorizationChannelInterceptor;
    private final SubscriptionAuthorizationChannelInterceptor subscriptionAuthorizationChannelInterceptor;
    private final UserCommunicationSecurityProperties securityProperties;

    public void addArgumentResolvers(List<HandlerMethodArgumentResolver> argumentResolvers) {
        argumentResolvers.add((HandlerMethodArgumentResolver)new AuthenticationPrincipalArgumentResolver());
    }

    public void configureClientInboundChannel(ChannelRegistration registration) {
        AuthenticationChannelInterceptor authenticationChannelInterceptor = new AuthenticationChannelInterceptor(this.securityProperties.getAudience(), (JwtTokenVerifier)this.jwtTokenVerifier.orElse(null));
        registration.interceptors(new ChannelInterceptor[]{authenticationChannelInterceptor, new SecurityContextChannelInterceptor(), this.authorizationChannelInterceptor, this.subscriptionAuthorizationChannelInterceptor});
    }

    public void configureClientOutboundChannel(ChannelRegistration registration) {
        registration.interceptors(new ChannelInterceptor[]{new /* Unavailable Anonymous Inner Class!! */});
    }

    @Generated
    public WebSocketSecurityConfig(Optional<JwtTokenVerifier> jwtTokenVerifier, AuthorizationChannelInterceptor authorizationChannelInterceptor, SubscriptionAuthorizationChannelInterceptor subscriptionAuthorizationChannelInterceptor, UserCommunicationSecurityProperties securityProperties) {
        this.jwtTokenVerifier = jwtTokenVerifier;
        this.authorizationChannelInterceptor = authorizationChannelInterceptor;
        this.subscriptionAuthorizationChannelInterceptor = subscriptionAuthorizationChannelInterceptor;
        this.securityProperties = securityProperties;
    }
}

