/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.usercommunication.dm.security;

import com.finconsgroup.itserr.messaging.security.OAuth2ClientCredentialsProvider;
import jakarta.annotation.PostConstruct;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.messaging.simp.stomp.StompBrokerRelayMessageHandler;

public class StompOAuth2ClientCredentialsWithRefreshProvider
extends OAuth2ClientCredentialsProvider {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StompOAuth2ClientCredentialsWithRefreshProvider.class);
    private final StompBrokerRelayMessageHandler stompBrokerRelayMessageHandler;

    public StompOAuth2ClientCredentialsWithRefreshProvider(String tokenEndpointUri, String clientId, String clientSecret, String grantType, Map<String, String> parameters, Duration refreshDelay, Duration refreshPeriod, ScheduledExecutorService scheduledExecutor, StompBrokerRelayMessageHandler stompBrokerRelayMessageHandler) {
        super(tokenEndpointUri, clientId, clientSecret, grantType, parameters, refreshDelay, refreshPeriod, scheduledExecutor);
        this.stompBrokerRelayMessageHandler = stompBrokerRelayMessageHandler;
    }

    @PostConstruct
    public void start() {
        this.refresh();
    }

    public void refresh() {
        super.refresh();
        String password = this.getPassword();
        if (this.stompBrokerRelayMessageHandler != null) {
            if (password != null && !password.isEmpty()) {
                this.stompBrokerRelayMessageHandler.setClientPasscode(password);
                this.stompBrokerRelayMessageHandler.setSystemPasscode(password);
                if (this.stompBrokerRelayMessageHandler.isRunning()) {
                    this.stompBrokerRelayMessageHandler.stop();
                    this.stompBrokerRelayMessageHandler.setTcpClient(null);
                    if (!this.stompBrokerRelayMessageHandler.isRunning()) {
                        this.stompBrokerRelayMessageHandler.start();
                    }
                }
            } else {
                log.warn("Stomp broker relay message handler password is empty");
            }
        }
    }
}

