/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.usercommunication.dm.repository;

import com.finconsgroup.itserr.marketplace.usercommunication.dm.entity.ConversationParticipant;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.enums.ParticipantRole;
import java.time.Instant;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface ConversationParticipantRepository
extends JpaRepository<ConversationParticipant, UUID> {
    public Optional<ConversationParticipant> findByConversationIdAndUserId(UUID var1, UUID var2);

    public List<ConversationParticipant> findByConversationIdAndActiveIsTrue(UUID var1);

    public List<ConversationParticipant> findByUserIdAndActiveIsTrue(UUID var1);

    public boolean existsByConversationIdAndUserIdAndActiveIsTrue(UUID var1, UUID var2);

    @Query(value="SELECT CASE WHEN COUNT(cp) > 0 THEN true ELSE false END FROM ConversationParticipant cp WHERE cp.conversationId = :conversationId AND cp.userId = :userId AND cp.active = true AND (cp.role = 'OWNER' OR cp.role = 'ADMIN')")
    public boolean hasAdminPrivileges(@Param(value="conversationId") UUID var1, @Param(value="userId") UUID var2);

    public long countByConversationIdAndActiveIsTrue(UUID var1);

    @Modifying
    @Query(value="UPDATE ConversationParticipant cp SET cp.role = :role WHERE cp.conversationId = :conversationId AND cp.userId = :userId")
    public void updateParticipantRole(@Param(value="conversationId") UUID var1, @Param(value="userId") UUID var2, @Param(value="role") ParticipantRole var3);

    @Modifying
    @Query(value="UPDATE ConversationParticipant cp SET cp.active = :isActive WHERE cp.conversationId = :conversationId AND cp.userId = :userId")
    public void updateParticipantActiveStatus(@Param(value="conversationId") UUID var1, @Param(value="userId") UUID var2, @Param(value="isActive") boolean var3);

    @Modifying
    @Query(value="UPDATE ConversationParticipant cp SET cp.muted = :isMuted WHERE cp.conversationId = :conversationId AND cp.userId = :userId")
    public void updateParticipantMuteStatus(@Param(value="conversationId") UUID var1, @Param(value="userId") UUID var2, @Param(value="isMuted") boolean var3);

    @Modifying
    @Query(value="UPDATE ConversationParticipant cp SET cp.notificationEnabled = :enabled WHERE cp.conversationId = :conversationId AND cp.userId = :userId")
    public void updateNotificationSettings(@Param(value="conversationId") UUID var1, @Param(value="userId") UUID var2, @Param(value="enabled") boolean var3);

    @Modifying
    @Query(value="UPDATE ConversationParticipant cp SET cp.lastReadAt = :timestamp WHERE cp.conversationId = :conversationId AND cp.userId = :userId")
    public void updateLastReadAt(@Param(value="conversationId") UUID var1, @Param(value="userId") UUID var2, @Param(value="timestamp") Instant var3);

    @Modifying
    @Query(value="UPDATE ConversationParticipant cp SET cp.active = false WHERE cp.conversationId = :conversationId AND cp.userId = :userId")
    public void removeParticipant(@Param(value="conversationId") UUID var1, @Param(value="userId") UUID var2);

    @Query(value="SELECT cp FROM ConversationParticipant cp WHERE cp.userId = :userId AND cp.active = true AND (cp.lastReadAt IS NULL OR cp.lastReadAt < (SELECT MAX(cm.createdAt) FROM ChatMessage cm WHERE cm.conversationId = cp.conversationId))")
    public List<ConversationParticipant> findConversationsWithUnreadMessages(@Param(value="userId") UUID var1);
}

