/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.usercommunication.dm.constant;

import com.finconsgroup.itserr.marketplace.usercommunication.dm.configuration.properties.WebSocketConfigurationProperties;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;

@Component
public final class MessageDestinations {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MessageDestinations.class);
    private static final String CONVERSATION_CHILD_SEPARATOR = "--";
    private static final String USER_MESSAGES_SUFFIX = "/queue/messages";
    private static final String USER_NOTIFICATIONS_SUFFIX = "/queue/notifications";
    private static final String USER_INVITATIONS_SUFFIX = "/queue/invitations";
    private final String userDestinationPrefix;
    private final String userErrors;
    private final String topicConversationPrefix;
    private final String topicUserStatus;
    private final String topicUserBroadcast;
    private final String topicUserRegistry;

    public MessageDestinations(WebSocketConfigurationProperties webSocketConfigurationProperties) {
        String destinationPrefix = webSocketConfigurationProperties.isEnableBrokerRelay() ? webSocketConfigurationProperties.getRelayDestinationPrefix() : "";
        this.userDestinationPrefix = "/%suser".formatted(destinationPrefix);
        this.userErrors = "%s/queue/errors".formatted(this.userDestinationPrefix);
        this.topicConversationPrefix = "/topic/%sconversation-".formatted(destinationPrefix);
        this.topicUserStatus = "/topic/%suser-status".formatted(destinationPrefix);
        this.topicUserBroadcast = "/topic/%sunresolved-user".formatted(destinationPrefix);
        this.topicUserRegistry = "/topic/%suser-registry".formatted(destinationPrefix);
    }

    public String getUserMessagesSuffix() {
        return USER_MESSAGES_SUFFIX;
    }

    public String getUserNotificationsSuffix() {
        return USER_NOTIFICATIONS_SUFFIX;
    }

    public String getUserInvitationsSuffix() {
        return USER_INVITATIONS_SUFFIX;
    }

    public boolean isUserMessages(String destination) {
        return destination.endsWith(USER_MESSAGES_SUFFIX);
    }

    public boolean isUserNotifications(String destination) {
        return destination.endsWith(USER_NOTIFICATIONS_SUFFIX);
    }

    public boolean isTopicConversation(String destination) {
        return destination.startsWith(this.topicConversationPrefix);
    }

    public boolean isUserMessagesOrTopicConversation(String destination) {
        return this.isUserMessages(destination) || this.isTopicConversation(destination);
    }

    public String getConversationTopic(UUID conversationId) {
        return this.topicConversationPrefix + String.valueOf(conversationId);
    }

    public String getConversationTypingTopic(UUID conversationId) {
        return this.getConversationChildTopic(conversationId, "typing");
    }

    public String getConversationChildTopic(UUID conversationId, String child) {
        return this.topicConversationPrefix + String.valueOf(conversationId) + CONVERSATION_CHILD_SEPARATOR + child;
    }

    public String getUserDestinationBroadcastTopic() {
        return this.topicUserBroadcast;
    }

    public String getUserRegistryBroadcastTopic() {
        return this.topicUserRegistry;
    }

    @NonNull
    public UUID extractConversationId(@NonNull String destination) {
        if (!this.isTopicConversation(destination)) {
            throw new IllegalArgumentException("Destination is not a conversation topic");
        }
        String conversationTopicSuffix = destination.replace(this.topicConversationPrefix, "");
        String[] conversationTopicParts = conversationTopicSuffix.split(CONVERSATION_CHILD_SEPARATOR, 2);
        if (conversationTopicParts.length > 0) {
            try {
                return UUID.fromString(conversationTopicParts[0]);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Error converting string " + conversationTopicParts[0] + " to uuid", e);
            }
        }
        throw new IllegalArgumentException("Invalid conversationTopicSuffix: " + conversationTopicSuffix);
    }

    @Generated
    public String getUserDestinationPrefix() {
        return this.userDestinationPrefix;
    }

    @Generated
    public String getUserErrors() {
        return this.userErrors;
    }

    @Generated
    public String getTopicConversationPrefix() {
        return this.topicConversationPrefix;
    }

    @Generated
    public String getTopicUserStatus() {
        return this.topicUserStatus;
    }

    @Generated
    public String getTopicUserBroadcast() {
        return this.topicUserBroadcast;
    }

    @Generated
    public String getTopicUserRegistry() {
        return this.topicUserRegistry;
    }
}

