/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.usercommunication.dm.component;

import com.finconsgroup.itserr.marketplace.usercommunication.dm.constant.MessageDestinations;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.entity.User;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.security.WebSocketAuthentication;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.security.WebSocketUser;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.service.OfflineMessageService;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.service.SessionManagementService;
import java.security.Principal;
import java.time.Instant;
import java.time.LocalDateTime;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.event.EventListener;
import org.springframework.messaging.Message;
import org.springframework.messaging.simp.SimpMessagingTemplate;
import org.springframework.messaging.simp.stomp.StompHeaderAccessor;
import org.springframework.stereotype.Component;
import org.springframework.web.socket.messaging.SessionConnectedEvent;
import org.springframework.web.socket.messaging.SessionDisconnectEvent;
import org.springframework.web.socket.messaging.SessionSubscribeEvent;

@Component
public class WebSocketEventListener
implements InitializingBean,
DisposableBean {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WebSocketEventListener.class);
    private final SessionManagementService sessionManagementService;
    private final SimpMessagingTemplate messagingTemplate;
    private final OfflineMessageService offlineMessageService;
    private final MessageDestinations messageDestinations;
    private ScheduledExecutorService scheduledExecutor;

    @EventListener
    public void handleWebSocketConnectListener(SessionConnectedEvent event) {
        User updatedUser;
        log.info("WebSocket connection established: {}", (Object)event.getMessage());
        StompHeaderAccessor headerAccessor = StompHeaderAccessor.wrap((Message)event.getMessage());
        String sessionId = headerAccessor.getSessionId();
        WebSocketUser user = this.extractUserFromHeaders(headerAccessor);
        if (user != null && sessionId != null && (updatedUser = this.sessionManagementService.onSessionCreated(sessionId, user)) != null) {
            this.broadcastUserStatusChange(updatedUser);
        }
    }

    @EventListener
    public void handleWebSocketDisconnectListener(SessionDisconnectEvent event) {
        User updatedUser;
        StompHeaderAccessor headerAccessor = StompHeaderAccessor.wrap((Message)event.getMessage());
        String sessionId = headerAccessor.getSessionId();
        if (sessionId != null && (updatedUser = this.sessionManagementService.onSessionDestroyed(sessionId)) != null) {
            this.broadcastUserStatusChange(updatedUser);
        }
    }

    @EventListener
    public void handleWebSocketSubscribeListener(SessionSubscribeEvent event) {
        StompHeaderAccessor headerAccessor = StompHeaderAccessor.wrap((Message)event.getMessage());
        String sessionId = headerAccessor.getSessionId();
        String destination = headerAccessor.getDestination();
        WebSocketUser user = this.extractUserFromHeaders(headerAccessor);
        if (user != null && sessionId != null) {
            UUID userId = user.getUserId();
            int userSessionCount = this.sessionManagementService.getUserSessionCount(userId);
            if (destination != null && this.messageDestinations.isUserMessagesOrTopicConversation(destination) && userSessionCount == 1) {
                this.scheduledExecutor.schedule(() -> {
                    try {
                        long messageCount = this.offlineMessageService.getUndeliveredMessageCount(userId);
                        if (messageCount > 0L) {
                            this.offlineMessageService.deliverOfflineMessages(userId);
                        } else {
                            log.debug("User {} came online with no pending messages", (Object)userId);
                        }
                    }
                    catch (Exception e) {
                        log.warn("Error while handling offline messages for user {}", (Object)userId);
                    }
                }, 200L, TimeUnit.MILLISECONDS);
            }
            if (destination != null && this.messageDestinations.isUserNotifications(destination)) {
                this.scheduledExecutor.schedule(() -> {
                    try {
                        this.offlineMessageService.notifyUserAboutPendingMessages(userId);
                        log.info("Sent detailed notification with sender info for user {} after subscription to notifications queue", (Object)userId);
                    }
                    catch (Exception e) {
                        log.warn("Error while sending pending messages notification to user {}", (Object)userId);
                    }
                }, 500L, TimeUnit.MILLISECONDS);
            }
            log.info("User {} subscribed to {} (session: {}, total sessions: {})", new Object[]{userId, destination, sessionId, userSessionCount});
        }
    }

    public void afterPropertiesSet() {
        log.info("Started the web socket event listener scheduled executor");
        this.scheduledExecutor = Executors.newSingleThreadScheduledExecutor();
    }

    public void destroy() {
        if (this.scheduledExecutor != null) {
            this.scheduledExecutor.shutdown();
            log.info("Stopped the web socket event listener scheduled executor");
        }
    }

    private WebSocketUser extractUserFromHeaders(StompHeaderAccessor headerAccessor) {
        Principal principal = headerAccessor.getUser();
        if (principal instanceof WebSocketAuthentication) {
            WebSocketAuthentication authentication = (WebSocketAuthentication)principal;
            return authentication.getPrincipal();
        }
        return null;
    }

    private void broadcastUserStatusChange(User user) {
        try {
            LinkedHashMap<String, Instant> statusUpdate = new LinkedHashMap<String, Instant>(Map.of("type", "USER_STATUS_UPDATE", "userId", user.getId(), "online", user.isOnline(), "timestamp", LocalDateTime.now().toString(), "lastSeen", user.getLastSeen()));
            this.messagingTemplate.convertAndSend((Object)this.messageDestinations.getTopicUserStatus(), statusUpdate);
            log.debug("Broadcasted status change for user {}: online={}", (Object)user.getId(), (Object)user.isOnline());
        }
        catch (Exception e) {
            log.error("Failed to broadcast status change for user {}: {}", new Object[]{user.getId(), e.getMessage(), e});
        }
    }

    @Generated
    public WebSocketEventListener(SessionManagementService sessionManagementService, SimpMessagingTemplate messagingTemplate, OfflineMessageService offlineMessageService, MessageDestinations messageDestinations) {
        this.sessionManagementService = sessionManagementService;
        this.messagingTemplate = messagingTemplate;
        this.offlineMessageService = offlineMessageService;
        this.messageDestinations = messageDestinations;
    }
}

