/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.usercommunication.dm.component;

import com.finconsgroup.itserr.marketplace.usercommunication.dm.entity.ChatMessage;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.service.ChatMessageService;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@ConditionalOnProperty(value={"type"}, prefix="user-communication.dm.messaging", havingValue="RABBIT")
@Component
public class ChatMessageConsumer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ChatMessageConsumer.class);
    private final ChatMessageService chatMessageService;

    @RabbitListener(queues={"${user-communication.dm.messaging.rabbit.chat.chat-queue}"})
    public void receiveChatMessage(ChatMessage message) {
        log.info("Received chat message: {} from user: {} in conversation: {}", new Object[]{message.getId(), message.getSenderId(), message.getConversationId()});
        this.chatMessageService.handleChatMessage(message);
    }

    @RabbitListener(queues={"${user-communication.dm.messaging.rabbit.chat.user-notification-queue}"})
    public void receiveUserNotification(ChatMessage notification) {
        log.info("Received user notification: {} for user: {}", (Object)notification.getId(), (Object)notification.getReceiverId());
        this.chatMessageService.handleUserNotification(notification);
    }

    @Generated
    public ChatMessageConsumer(ChatMessageService chatMessageService) {
        this.chatMessageService = chatMessageService;
    }
}

