/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.usercommunication.dm.component;

import com.finconsgroup.itserr.marketplace.usercommunication.dm.bean.ChatMessageApplicationEvent;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.entity.ChatMessage;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.service.ChatMessageService;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.ApplicationListener;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;

@ConditionalOnProperty(value={"type"}, prefix="user-communication.dm.messaging", havingValue="SPRING_EVENTS")
@Component
public class ChatApplicationEventListener
implements ApplicationListener<ChatMessageApplicationEvent> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ChatApplicationEventListener.class);
    private final ChatMessageService chatMessageService;

    public void onApplicationEvent(@NonNull ChatMessageApplicationEvent event) {
        ChatMessage message = event.getChatMessage();
        if (event.isUserNotification()) {
            log.info("Received user notification: {} for user: {}", (Object)message.getId(), (Object)message.getReceiverId());
            this.chatMessageService.handleUserNotification(message);
        } else {
            log.info("Received chat message: {} from user: {} in conversation: {}", new Object[]{message.getId(), message.getSenderId(), message.getConversationId()});
            this.chatMessageService.handleChatMessage(message);
        }
    }

    @Generated
    public ChatApplicationEventListener(ChatMessageService chatMessageService) {
        this.chatMessageService = chatMessageService;
    }
}

